package jp.kitec.lib.io;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/**
 * @author kamimura
 */
public class Base64Encoder {

	protected Base64Encoder() {
	}

	public static String encode(byte[] source, int user_len) {

		int len;
		if(user_len > 76 || user_len%4 !=0 ){
			len = 76;
		}else{
			len = user_len;
		}

		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		PrintStream ps = new PrintStream(bos);


		int length;
		int character_counter = 0;
		String buffer = "";

		length = source.length / 3;

		for(int i=0;i<length;i++){
			buffer = buffer + encode3bytes( source , i*3 ,3 );
			character_counter++;
			if(character_counter == len/4){

				ps.println(buffer);
				buffer = "";
				character_counter = 0;
			}
		}

		if(source.length % 3 == 2){
			buffer = buffer + encode3bytes( source , source.length - 2 , 2 );
			ps.println(buffer);
		}else if(source.length % 3 == 1){
			buffer = buffer + encode3bytes( source , source.length - 1, 1 );
			ps.println(buffer);
		}else{
			if(character_counter != 0){
				ps.println(buffer);
			}
		}
		return bos.toString();

	}

	public static String encode(byte[] source){
		return encode(source, 72);
	}


	/**
	 * 3バイトを4文字に変換
	 * @param source
	 * @param position
	 * @param num
	 * @return
	 * String
	 *
	 */
	private static String encode3bytes(byte[] source,int position, int num){
		char[] encoded = new char[4];
		String result = "";
		int z = 0;
		if ( num == 1 ){
			byte byte1 = source[position];
			encoded[0] = traslation_array[ byte1 >>> 2 & 0x3f];
			encoded[1] = traslation_array[(byte1 <<  4 & 0x30) + (z >>> 4 & 0xf)];
			encoded[2] = 61;//"="
			encoded[3] = 61;//"="
			result = new String(encoded);

		}else if(num == 2){
			byte byte1 = source[position];
			byte byte2 = source[position + 1];
			encoded[0] = traslation_array[ byte1 >>> 2 & 0x3f ];
			encoded[1] = traslation_array[(byte1 <<  4 & 0x30 ) + ( byte2 >>> 4 & 0xf )];
			encoded[2] = traslation_array[(byte2 <<  2 & 0x3c ) + ( z >>> 6 & 3)];
			encoded[3] = 61;//"="
			result = new String(encoded);

		}else{
			byte byte1 = source[position];
			byte byte2 = source[position + 1];
			byte byte3 = source[position + 2];
			encoded[0] = traslation_array[ byte1 >>> 2 & 0x3f ];
			encoded[1] = traslation_array[(byte1 <<  4 & 0x30) + ( byte2 >>> 4 & 0xf )];
			encoded[2] = traslation_array[(byte2 <<  2 & 0x3c) + ( byte3 >>> 6 & 3)];
			encoded[3] = traslation_array[ byte3 & 0x3f];
			result = new String(encoded);
		}

		return result;
	}


	private static final char[] traslation_array = {
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
		'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
		'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd',
		'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
		'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x',
		'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7',
		'8', '9', '+', '/'
	};

}
