/**
 *
 */
package jp.kitec.lib.geom;

import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KArea;

/**
 * 
 * @since 2007/10/12
 * @author kamimura
 * @version 2007/10/12
 */
public class KPathQuad2d extends KPath2d {

	/** 制御点1 */
	protected double mCX1, mCY1;

	/**
	 * コンストラクタ.
	 * 
	 * @since 2007/10/12
	 * @author kamimura
	 */
	public KPathQuad2d() {
	}

	@Override
	public int getType() {
		return IRichGraphics.DEF_SEG_QUAD;
	}

	@Override
	public int getNumberSize() {
		return 4;
	}

	/*
	 * @see nethome.geom.primitive.GPath2df#getX(float, double)
	 * 
	 * @since 2007/10/15
	 */
	public double getX(double x1, double param) {
		if (param < 0 || param > 1)
			return x1;
		double s = 1 - param;
		return s * (s * x1 + param * mCX1) + param * (s * mCX1 + param * mX1);
	}

	/*
	 * @see nethome.geom.primitive.GPath2df#getY(float, double)
	 * 
	 * @since 2007/10/15
	 */
	public double getY(double y1, double param) {
		if (param < 0 || param > 1)
			return y1;
		double s = 1 - param;
		return s * (s * y1 + param * mCY1) + param * (s * mCY1 + param * mY1);
	}

	/*
	 * @see
	 * nethome.geom.primitive.GPath2df#appendPath(jp.kitec.kwt.IRichGraphics,
	 * nethome.geom.LocalAxis2Df, nethome.geom.primitive.GPathShape)
	 * 
	 * @since 2007/10/12
	 */
	@Override
	public void appendPath(IRichGraphics d, KLocalAxis la, KLocalAxis la2) {
		if (la == null) {
			d.pathQuadTo(mCX1, mCY1, mX1, mY1, la2);
		} else {
			double cx1 = la.getGlobalX(mCX1, mCY1);
			double cy1 = la.getGlobalY(mCX1, mCY1);
			double mx1 = la.getGlobalX(mX1, mY1);
			double my1 = la.getGlobalY(mX1, mY1);
			d.pathQuadTo(cx1, cy1, mx1, my1, la2);
		}
	}

	/*
	 * @see nethome.geom.primitive.GPath2df#getPoints(double[])
	 * 
	 * @since 2007/10/12
	 */
	@Override
	public void getPoints(double[] points) {
		points[0] = this.mCX1;
		points[1] = this.mCY1;
		points[2] = this.mX1;
		points[3] = this.mY1;
	}

	/*
	 * @see nethome.geom.primitive.GPath2df#updateMinMax(jp.kitec.kwt.Area,
	 * double, double)
	 * 
	 * @since 2007/10/12
	 */
	@Override
	public void updateMinMax(KArea area, double x1, double y1) {
		double a, b;

		a = x1 - 2 * mCX1 + mX1;
		b = -2 * x1 + 2 * mCX1;
		if (a != 0) {
			double cx = -b / (2 * a);
			if (0 <= cx && cx <= 1) {
				area.updateMinMax(getX(x1, cx), getY(y1, cx));
			}
		}

		a = y1 - 2 * mCY1 + mY1;
		b = -2 * y1 + 2 * mCY1;
		if (a != 0) {
			double cy = -b / (2 * a);
			if (0 <= cy && cy <= 1) {
				area.updateMinMax(getX(x1, cy), getY(y1, cy));
			}
		}

		// 両端
		area.updateMinMax(x1, y1);
		area.updateMinMax(mX1, mY1);
	}
}
