/*
 * Copyright (c) 2009-2010 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;



/**
 * リフレクション対象を表すアノテーション<br/>
 * このアノテーションが付属するクラスは、縮小化されてはいけない。<br/>
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
@Inherited
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@DontShrink
public @interface Reflectable {
	/** 名称。難読化されても固定的な名称を取得する際に使用。 */
	String name() default "";
}
