/*
 * Copyright (c) 2010 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;



/**
 * 難読化不許可を表すアノテーション<br/>
 * このアノテーションが付属するクラスは、難読化されてはいけない。<br/>
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
@Inherited
@Target({ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@DontShrink
public @interface DontObfuscate {
}
