/*
 * Created on 2004/11/12
 */
package jp.kitec.lib.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * classオブジェクトのユーティリティ
 *
 * @author kawae
 * @since 2004/11/12
 */
public class UtilObject {

	private static final Log log = LogFactory.getLog(UtilObject.class);

	/**
	 * オブジェクトのコピー
	 * @param o
	 * @return
	 * @author kawae
	 * @since 2004/11/12
	 */
	public static Object getCopy(Object o) {
		Object copyObject=null;
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		try {
			ObjectOutputStream oos = new ObjectOutputStream(bos);
			oos.writeObject(o);
			ObjectInputStream ois = new ObjectInputStream(
				new ByteArrayInputStream(bos.toByteArray()));
			copyObject = ois.readObject();
		} catch (IOException e) {
			log.error("コピーエラー", e);
		} catch (ClassNotFoundException e) {
			log.error("コピーエラー", e);
		}
		return copyObject;
	}
}
