/*
 * Copyright (c) 2008-2010 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.util;

import java.util.HashMap;
import java.util.Map;



/**
 * Framework用クラス情報管理クラス
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class ClassInfoManager {

	//------------------------------------------------------------------
	//- fields
	//------------------------------------------------------------------

	/** インスタンス */
	protected static ClassInfoManager mInstance = new ClassInfoManager();

	/** キャッシュ有効/無効 */
	protected boolean mCacheable = true;

	/** クラス情報マップ */
	protected Map<String, ClassInfo> mStringKeyMap = new HashMap<String, ClassInfo>();



	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected ClassInfoManager() {
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	/**
	 * インスタンスを取得する。
	 *
	 * @return インスタンス
	 */
	public static ClassInfoManager getInstance() {
		return mInstance;
	}

	/**
	 * クラス情報を取得する。
	 *
	 * @param clazz 対象クラス
	 * @return クラス情報
	 */
	public ClassInfo getClassInfo(final Class<?> clazz) {
		ClassInfo classInfo = null;
		if (this.mCacheable) {
			classInfo = this.mStringKeyMap.get(clazz.getName());
		}
		if (classInfo == null) {
			classInfo = new ClassInfo(clazz);
			this.mStringKeyMap.put(classInfo.getType().getName(), classInfo);
		}
		return classInfo;
	}

	/**
	 * クラス情報を取得する。
	 *
	 * @param clazzName 対象クラス名
	 * @return クラス情報
	 */
	public ClassInfo getClassInfo(final String clazzName) {
		ClassInfo classInfo = null;
		if (this.mCacheable) {
			classInfo = this.mStringKeyMap.get(clazzName);
		}
		if (classInfo == null) {
			Class<?> clazz = null;
			try {
				clazz = Class.forName(clazzName);
			} catch (ClassNotFoundException e) {
			}
			if (clazz != null) {
				classInfo = new ClassInfo(clazz);
				this.mStringKeyMap.put(clazzName, classInfo);
			}
		}
		return classInfo;
	}



	//------------------------------------------------------------------
	//- setter / getter
	//------------------------------------------------------------------

	/**
	 * キャッシュ有効/無効を設定する。
	 *
	 * @param cacheable キャッシュ有効の場合true。
	 */
	public void setCacheable(boolean cacheable) {
		this.mCacheable = cacheable;
	}



} // end-class
