/*
 * Copyright (c) 2009-2010 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.io;

import java.io.File;
import java.io.FileNotFoundException;



/**
 * ファイルが見つからないことを表すRuntimeExceptionです。
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class FileNotFoundRuntimeException extends RuntimeException {

    //------------------------------------------------------------------
    //- constructors
    //------------------------------------------------------------------

    /**
     * コンストラクタ
     */
    public FileNotFoundRuntimeException() {
        super();
    }

    /**
     * コンストラクタ
     *
     * @param e FileNotFoundException
     */
    public FileNotFoundRuntimeException(FileNotFoundException e) {
        super(e);
    }

    /**
     * コンストラクタ
     *
     * @param file File
     */
    public FileNotFoundRuntimeException(File file) {
        super(file.toString());
    }



} // end-class
