package jp.kitec.lib.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * すべてのファイルを抽象化したクラス。<BR>
 *
 * @since 　2002/12/20
 * @author　Kawae
 * @version 2002/12/20
 *
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
 */
public class AbstFileUtil {

	private static final Log log = LogFactory.getLog(AbstFileUtil.class);

	/**
	 * 空の AbstFile を構築する。
	 * 
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	protected AbstFileUtil() {
	}

	/**
	 * 指定されたファイルからデータを読み込み、内部データへ保存する。
	 *
	 * @param f	ファイル
	 * @return 読み込みに成功した場合、true。
	 * 			読み込みに失敗した場合は、false。
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	public static boolean read(AbstFile af, File f) {
		boolean ret = false;
		try {
			FileInputStream is = new FileInputStream(f);
			if (f.length() < Integer.MAX_VALUE)
				ret = af.read(is, f.getAbsolutePath(), (int)f.length());
			else
				ret = af.read(is, f.getAbsolutePath());
			is.close();
		} catch (Exception e) {
			log.error("ファイル読込エラー", e);
			return false;
		}
		return ret;
	}

	public static void dbgSaveFile(File f, byte[] data) throws IOException {
		FileOutputStream fos = new FileOutputStream(f);
		fos.write(data);
		fos.close();
	}
}
