/*
 * Created on 2006/01/13
 */
package jp.kitec.lib.geom;


/**
 * ２次元線要素のインターフェース
 *
 * @author kawae
 * @since 2006/01/13
 */
public interface K2DPathFigureLine extends K2DPathFigure {
	/**
	 * 図形の始点のＸ座標値を取得する。
	 *
	 * Coded on 2005/07/22
	 * @return	始点のＸ座標値
	 */
	public double getX1();

	/**
	 * 図形の始点のＹ座標値を取得する。
	 *
	 * Coded on 2005/07/22
	 * @return	始点のＹ座標値
	 */
	public double getY1();

	/**
	 * 図形の終点のＸ座標地を取得する。
	 *
	 * Coded on 2005/07/22
	 * @return	終点のＸ座標値
	 */
	public double getX2();

	/**
	 * 図形の終点のＹ座標値を取得する。
	 *
	 * Coded on 2005/07/22
	 * @return	終点のＹ座標値
	 */
	public double getY2();

	/**
	 * 図形の始点のＸ座標値をセットする。
	 *
	 * Coded on 2005/07/25
	 * @param x	始点のＸ座標値
	 */
	public void setX1( double x );

	/**
	 * 図形の始点のＹ座標値をセットする。
	 *
	 * Coded on 2005/07/22
	 * @param y	始点のＹ座標値
	 */
	public void setY1( double y );

	/**
	 * 図形の終点のＸ座標地をセットする。
	 *
	 * Coded on 2005/07/22
	 * @param x	終点のＸ座標値
	 */
	public void setX2( double x );

	/**
	 * 図形の終点のＹ座標値をセットする。
	 *
	 * Coded on 2005/07/22
	 * @param y	終点のＹ座標値
	 */
	public void setY2( double y );
}
