package jp.kitec.kwt;

import java.io.Serializable;

import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;

import jp.kitec.lib.util.MathUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;


public class KRotatedArea implements Serializable {
	private static final long serialVersionUID = 1L;
	public static final String GEOMNAME = "ROTATEDAREA";

	private Point2d center;
	private Vector2d size;
	private double rotation;

	public KRotatedArea() {
		center = new Point2d();
		size = new Vector2d();
	}

	public void set(KRotatedArea a) {
		center.set(a.center);
		size.set(a.size);
		rotation = a.rotation;
	}

	public Point2d getCenter() {
		return center;
	}

	public void setCenter(Point2d center) {
		this.center.set(center);
	}

	public Vector2d getSize() {
		return size;
	}

	public double getCX() {
		return center.x;
	}

	public double getCY() {
		return center.y;
	}

	public double getWidth() {
		return size.x;
	}

	public double getHeight() {
		return size.y;
	}

	public void setSize(Vector2d size) {
		this.size.set(size);
	}

	public double getRotation() {
		return rotation;
	}

	public void setRotation(double rotation) {
		this.rotation = rotation;
	}

	public void updateMinMax(KArea area) {
		double sin = Math.sin(rotation);
		double cos = Math.cos(rotation);

		area.updateMinMax(center.x + size.x / 2 * cos - size.y / 2 * sin,
				center.y + size.x / 2 * sin + size.y / 2 * cos);
		area.updateMinMax(center.x + size.x / 2 * cos + size.y / 2 * sin,
				center.y + size.x / 2 * sin - size.y / 2 * cos);
		area.updateMinMax(center.x - size.x / 2 * cos + size.y / 2 * sin,
				center.y - size.x / 2 * sin - size.y / 2 * cos);
		area.updateMinMax(center.x - size.x / 2 * cos - size.y / 2 * sin,
				center.y - size.x / 2 * sin + size.y / 2 * cos);
	}

	public Vector2d getDirX() {
		return new Vector2d(Math.cos(rotation), Math.sin(rotation));
	}

	public Vector2d getDirY() {
		return new Vector2d(Math.cos(rotation + Math.PI / 2), Math.sin(rotation + Math.PI / 2));
	}

	public double distanceTo(double x, double y) {
		double cx = x - center.x;
		double cy = y - center.y;
		Vector2d p = new Vector2d(cx, cy);
		Vector2d dx = getDirX();
		Vector2d dy = getDirY();
		double ax = dx.dot(p);
		double ay = dy.dot(p);
		double sx = size.x / 2;
		double sy = size.y / 2;
		if (ax >= -sx / 2 && ax <= sx && ay >= -sy && ay <= sy)
			return 0;
		if (ax < -sx) {
			if (ay <= -sy) {
				return MathUtil.getLength2D(-sx, -sy, ax, ay);
			} else if (ay >= sy) {
				return MathUtil.getLength2D(-sx, sy, ax, ay);
			} else {
				return -sx - ax;
			}
		} else if (ax > sx) {
			if (ay <= -sy) {
				return MathUtil.getLength2D(sx, -sy, ax, ay);
			} else if (ay >= sy) {
				return MathUtil.getLength2D(sx, sy, ax, ay);
			} else {
				return ax - sx;
			}
		} else {
			if (ay <= -sy) {
				return -sy - ay;
			} else if (ay >= sy) {
				return ay - sy;
			} else {
				return 0;
			}
		}
	}

	public Point2d[] getPoints() {
		double sin = Math.sin(rotation);
		double cos = Math.cos(rotation);

		return new Point2d[] {
				new Point2d(center.x + size.x / 2 * cos - size.y / 2 * sin,
						center.y + size.x / 2 * sin + size.y / 2 * cos),
				new Point2d(center.x + size.x / 2 * cos + size.y / 2 * sin,
						center.y + size.x / 2 * sin - size.y / 2 * cos),
				new Point2d(center.x - size.x / 2 * cos + size.y / 2 * sin,
						center.y - size.x / 2 * sin - size.y / 2 * cos),
				new Point2d(center.x - size.x / 2 * cos - size.y / 2 * sin,
						center.y - size.x / 2 * sin + size.y / 2 * cos),
		};
	}

	public void save(ObjectFolder savenode) {
		savenode.setName(GEOMNAME);
		ObjectFolder.addNodeDouble(savenode, "cx", center.x);
		ObjectFolder.addNodeDouble(savenode, "cy", center.y);
		ObjectFolder.addNodeDouble(savenode, "sx", size.x);
		ObjectFolder.addNodeDouble(savenode, "sy", size.y);
		ObjectFolder.addNodeDouble(savenode, "rot", rotation);
	}

	public static void readData(ObjectFolder datanode, KRotatedArea r) {
		ObjectNode on;
		if ((on = datanode.getNode("cx")) != null)
			r.center.x = on.getDouble(0);
		if ((on = datanode.getNode("cy")) != null)
			r.center.y = on.getDouble(0);
		if ((on = datanode.getNode("sx")) != null)
			r.size.x = on.getDouble(0);
		if ((on = datanode.getNode("sy")) != null)
			r.size.y = on.getDouble(0);
		if ((on = datanode.getNode("rot")) != null)
			r.rotation = on.getDouble(0);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((center == null) ? 0 : center.hashCode());
		result = prime * result + Double.valueOf(rotation).hashCode();
		result = prime * result + ((size == null) ? 0 : size.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		KRotatedArea other = (KRotatedArea) obj;
		if (center == null) {
			if (other.center != null)
				return false;
		} else if (!center.equals(other.center))
			return false;
		if (Double.compare(rotation, other.rotation) != 0)
			return false;
		if (size == null) {
			if (other.size != null)
				return false;
		} else if (!size.equals(other.size))
			return false;
		return true;
	}
}
