package jp.kitec.lib.util.xml;


import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;

import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;


/**
 * @author kawae
 *
 * XMLWriterを例外をcatchしないように修正したもの
 */
public class XMLWriter {
	/**
	 * ライト
	 * @param f
	 * @param space
	 * @param w
	 * @throws Exception
	 */
	public static void write(ObjectNode f, String space, PrintStream o) throws IOException {
		write_(f, space, o);
	}

	public static void write(ObjectNode f, String space, Writer o) throws IOException {
		write_(f, space, o);
	}

	/**
	 *
	 * @param f
	 * @param space
	 * @param o
	 * @throws Exception
	 * @author kawae
	 * @since 2005/12/09
	 */
	private static void write_(ObjectNode f, String space, Object o) throws IOException {

		if (f instanceof ObjectFolder) {
			ObjectFolder of = (ObjectFolder) f;
			boolean hasFolder = false;
			boolean hasNode = false;
			for (int i = 0; i < of.getChildren().size(); i++) {
				if (of.getChildren().get(i) instanceof ObjectFolder) {
					hasFolder = true;
				} else if (of.getChildren().get(i) instanceof ObjectNode) {
					hasNode = true;
				}
			}

			if (hasNode)
				print(o, space + "<" + of.getName());
			else {
				if (of.getChildren() == null || of.getChildren().size() == 0) {
					println(o, space + "<" + of.getName() + "/>");
					return;
				}
				println(o, space + "<" + of.getName() + ">");
			}

			for (int i = 0; i < of.getChildren().size(); i++) {
				if (!(of.getChildren().get(i) instanceof ObjectFolder))
					write_(of.getChildren().get(i), space + " ", o);
			}
			if (hasNode && !hasFolder)
				println(o, "/>");
			else if (hasNode)
				println(o, ">");

			for (int i = 0; i < of.getChildren().size(); i++) {
				if (of.getChildren().get(i) instanceof ObjectFolder)
					write_(of.getChildren().get(i), space + " ", o);
			}
			if (hasFolder)
			println(o, space + "</" + of.getName() + ">");
	} else {
		ObjectNode on = f;
		if (on.getObject() != null) {
			// 特定の文字列が存在した場合、base64にする。
			String str = null;
			str = on.getObject().toString();
			boolean enc64 = false;
			for (String element : XMLManager.ENC_64_CHARS) {
				if (str.indexOf(element) >= 0) {
					enc64 = true;
					break;
				}
			}
			if (enc64)
				str = XMLManager.BASE64_TAG_BRGIN + jp.kitec.lib.io.Base64Encoder.encode(str.getBytes())
						+ XMLManager.BASE64_TAG_END;
			print(o, " " + on.getName() + "=\"" + str + "\"");
			// -->
		} else {
			print(o, " " + on.getName() + "=\"" + on.getObject() + "\"");
		}
	}





//		if (f instanceof ObjectFolder) {
//			ObjectFolder of = (ObjectFolder) f;
//			boolean hasFolder = false;
//			boolean hasNode = false;
//			for (int i = 0; i < of.getChildlen().size(); i++) {
//				if (of.getChildlen().elementAt(i) instanceof ObjectFolder) {
//					hasFolder = true;
//				} else if (of.getChildlen().elementAt(i) instanceof ObjectNode) {
//					hasNode = true;
//				}
//			}
//
//			if (hasNode)
//				print(o, space + "<" + of.getName());
//			else {
//				if (of.getChildlen() == null || of.getChildlen().size() == 0) {
//					println(o, space + "<" + of.getName() + "/>");
//					return;
//				}
//				println(o, space + "<" + of.getName() + ">");
//			}
//
//			for (int i = 0; i < of.getChildlen().size(); i++) {
//				if (!(of.getChildlen().elementAt(i) instanceof ObjectFolder))
//					write((ObjectNode) of.getChildlen().elementAt(i), space + " ", o);
//			}
//			if (hasNode && !hasFolder)
//				println(o, "/>");
//			else if (hasNode)
//				println(o, ">");
//
//			for (int i = 0; i < of.getChildlen().size(); i++) {
//				if (of.getChildlen().elementAt(i) instanceof ObjectFolder)
//					write((ObjectNode) of.getChildlen().elementAt(i), space + " ", o);
//			}
//			if (hasFolder)
//				println(o, space + "</" + of.getName() + ">");
//		} else {
//			ObjectNode on = f;
//			if (true) {
//				// <!--川会修正050811
//				// 特定の文字列が存在した場合、base64にする。
//				String str = null;
//				str = on.getObject().toString();
//				boolean enc64 = false;
//				for (int i = 0; i < XMLManager.ENC_64_CHARS.length; i++) {
//					if (str.indexOf(XMLManager.ENC_64_CHARS[i]) >= 0) {
//						enc64 = true;
//						break;
//					}
//				}
//				if (enc64)
//					str = XMLManager.BASE64_TAG_BRGIN + jp.kitec.lib.io.Base64Encoder.encode(str.getBytes())
//							+ XMLManager.BASE64_TAG_END;
//				print(o, " " + on.getName() + "=\"" + str + "\"");
//				// -->
//			} else {
//				print(o, " " + on.getName() + "=\"" + on.getObject() + "\"");
//			}
//		}
	}

	/**
	 *
	 * @param target
	 * @param message
	 * @author kawae
	 * @since 2005/12/09
	 */
	private static void print(Object target, String message) throws IOException {
		if (target instanceof PrintStream) {
			((PrintStream)target).print(message);
		} else if (target instanceof Writer){
			((Writer)target).write(message);
		}
	}

	/**
	 *
	 * @param target
	 * @param message
	 * @author kawae
	 * @since 2005/12/09
	 */
	private static void println(Object target, String message) throws IOException {
		if (target instanceof PrintStream) {
			((PrintStream)target).println(message);
		} else if (target instanceof Writer){
			((Writer)target).write(message + "\n");
		}
	}

}
