package jp.kitec.lib.util.xml;

import java.io.FileInputStream;
import java.io.InputStream;

import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.util.tree.ObjectFolder;



/**
 * XML 解析クラス。<BR>
 *
 * @since		2004/05/18
 * @author		fujita
 * @version	2004/05/18
 *
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
 */
public class XMLParser {

//	/** XML の解析結果としての木構造オブジェクト */
//	private ObjectFolder mObjFolder;
//
//
//	/**
//	 * XML の解析結果として、そのデータを表す
//	 * 木構造オブジェクトを返す。
//	 *
//	 * @return		木構造オブジェクト
//	 * @since		2004/05/19
//	 * @author		fujita
//	 * @version	2004/05/19
//	 */
//	public ObjectFolder getData() {
//		return mObjFolder;
//	}
//
//	/**
//	 * 指定された in から XML データを読み込む。
//	 *
//	 * @param		in	 XML データ入力オブジェクト
//	 * @return		 XML データを正しく読み込めた場合、true。
//	 * 				そうでない場合は、false
//	 * @since		2004/05/19
//	 * @author		fujita
//	 * @version	2004/05/19
//	 */
//	public boolean load(AbstFile in) {
//		ObjectFolder of = read(in);
//
//		if (of == null) {
//			return false;
//		}
//
//		mObjFolder = (ObjectFolder)of.getChildlen().elementAt(0);
////		testPrintTree(mObjFolder, 0);
//
//		return true;
//	}
//
//	/**
//	 * 指定された in から XML データを読み込む。
//	 *
//	 * @param		in	 XML データ入力ストリーム
//	 * @return		 XML データを正しく読み込めた場合、true。
//	 * 				そうでない場合は、false
//	 * @since		2004/05/19
//	 * @author		fujita
//	 * @version	2004/05/19
//	 */
//	public boolean load(InputStream in) {
//		return load(getInputFile(in));
//	}
//
//	/**
//	 * 指定された file から XML データを読み込む。
//	 *
//	 * @param		file	 XML データ入力ファイル（名）
//	 * @return		 XML データを正しく読み込めた場合、true。
//	 * 				そうでない場合は、false
//	 * @since		2004/05/19
//	 * @author		fujita
//	 * @version	2004/05/19
//	 */
//	public boolean load(String file) {
//		return load(getInputFile(file));
//	}

	/**
	 * 指定された in から XML データを読み込む。
	 *
	 * @param		in	XML データ入力オブジェクト
	 * @return		XML データを正しく読み込めた場合、
	 * 				そのデータを表す木構造オブジェクトtrue。
	 * 				そうでない場合は、null
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	public ObjectFolder load(AbstFile in) {
		ObjectFolder of = read(in, null);

		if (of == null) {
			return null;
		}

//		testPrintTree((ObjectFolder)of.getChildlen().elementAt(0), 0);

		return (ObjectFolder)of.getChildren().get(0);
	}

	public ObjectFolder load(AbstFile in, String encode) {
		ObjectFolder of = read(in, encode);

		if (of == null) {
			return null;
		}

//		testPrintTree((ObjectFolder)of.getChildlen().elementAt(0), 0);

		return (ObjectFolder)of.getChildren().get(0);
	}


	/**
	 * 指定された in から XML データを読み込む。
	 *
	 * @param		in	XML データ入力ストリーム
	 * @return		XML データを正しく読み込めた場合、
	 * 				そのデータを表す木構造オブジェクトtrue。
	 * 				そうでない場合は、null
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	public ObjectFolder load(InputStream in) {
		ObjectFolder of = load(getInputFile(in));
		if (of == null) {
			return null;
		}

		return (ObjectFolder)of.getChildren().get(0);
	}

	/**
	 * 指定された file から XML データを読み込む。
	 *
	 * @param		file	XML データ入力ファイル（名）
	 * @return		XML データを正しく読み込めた場合、
	 * 				そのデータを表す木構造オブジェクトtrue。
	 * 				そうでない場合は、null
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	public ObjectFolder load(String file) {
		return load(getInputFile(file));
	}

	/**
	 * 指定された in をもとに、データ読み込みオブジェクトを作成する。
	 *
	 * @param		in	入力ストリーム
	 * @return		データ読み込みオブジェクト
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	private AbstFile getInputFile(InputStream in) {
		if (in == null) return null;

		AbstFile af = new AbstFile();
		af.read(in, "");
		return af;
	}

	/**
	 * 指定された file をもとに、データ読み込みオブジェクトを作成する。
	 *
	 * @param		file	ファイル（名）
	 * @return		データ読み込みオブジェクト
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	private AbstFile getInputFile(String file) {
		InputStream in = getInputStream(file);
		if (in == null) return null;

		AbstFile af = new AbstFile();
		af.read(in, file);
		return af;
	}

	/**
	 * 指定された file をもとに、入力ストリームを作成する。
	 *
	 * @param		file	ファイル（名）
	 * @return		入力ストリーム
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	private InputStream getInputStream(String file) {
		try {
			return new FileInputStream(file);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 指定された in から XML データを読み込む。
	 *
	 * @param		in	 XML データ入力オブジェクト
	 * @return		 XML データを正しく読み込めた場合、そのデータを持つ
	 * 				データオブジェクト。そうでない場合は、null
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	private ObjectFolder read(AbstFile in, String encode) {
		if (in == null) {
			return null;
		}

//		ObjectFolder of = XMLReader.readFile(af);
//		if (of.getChildlen().size() < 1) {
//			return null;
//		}

		XMLReader xml = new XMLReader(in);
		if (encode == null)
			return xml.read();
		else
			return xml.read(encode);
	}
}