/*
 * Copyright (c) 2008 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.util;

import org.apache.commons.lang.builder.ToStringBuilder;



/**
 * 3つの値の組
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 *
 * @param <T1> 1番目の値の型
 * @param <T2> 2番目の値の型
 * @param <T3> 3番目の値の型
 */
public class Tuple3<T1, T2, T3> {

	/** 1番目の値 */
	public T1 value1;

	/** 2番目の値 */
	public T2 value2;

	/** 3番目の値 */
	public T3 value3;



	/**
	 * 3つの値の組を作成して返します。
	 *
	 * @param <T1> 1番目の値の型
	 * @param <T2> 2番目の値の型
	 * @param <T3> 3番目の値の型
	 * @return 3つの値の組
	 */
	public static <T1, T2, T3> Tuple3<T1, T2, T3> newInstance() {
		return new Tuple3<T1, T2, T3>();
	}

	/**
	 * 3つの値の組を作成して返します。
	 *
	 * @param <T1> 1番目の値の型
	 * @param <T2> 2番目の値の型
	 * @param <T3> 3番目の値の型
	 * @param value1 1番目の値
	 * @param value2 2番目の値
	 * @param value3 3番目の値
	 * @return 3つの値の組
	 */
	public static <T1, T2, T3> Tuple3<T1, T2, T3> newInstance(final T1 value1, final T2 value2, final T3 value3) {
		return new Tuple3<T1, T2, T3>(value1, value2, value3);
	}

	/**
	 * インスタンスを構築します。
	 */
	public Tuple3() {
	}

	/**
	 * インスタンスを構築します。
	 *
	 * @param value1 1番目の値
	 * @param value2 2番目の値
	 * @param value3 3番目の値
	 */
	public Tuple3(final T1 value1, final T2 value2, final T3 value3) {
		this.value1 = value1;
		this.value2 = value2;
		this.value3 = value3;
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this)
			.append(this.value1)
			.append(this.value2)
			.append(this.value3)
			.toString();
	}



} // end-class
