package jp.kitec.lib.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SerializeHistoryDataConverter implements HistoryDataConverter<Object, byte[]> {
	private static final Log log = LogFactory.getLog(SerializeHistoryDataConverter.class);

	@Override
	public byte[] writeHistory(Object o) {
		return writeBytes(o);
	}

	@Override
	public Object readHistory(byte[] h) {
		return readBytes(h);
	}

	/**
	 * 指定された履歴のバイト配列を返す。
	 *
	 * @return 履歴のバイト配列
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	private static byte[] writeBytes(Object o) {
		try {
			ByteArrayOutputStream fos = new ByteArrayOutputStream ();
			ObjectOutputStream out = new ObjectOutputStream(fos);
			out.writeObject(o);
			out.flush();
			fos.close();
			return fos.toByteArray();
		} catch (Exception e) {
			log.error("バイト列に変換中にエラー", e);
			if (e instanceof NotSerializableException) {
				NotSerializableException ex = (NotSerializableException)e;
				ex.fillInStackTrace();
				log.error("シリアライズエラー", e);
			}
		}
		return null;
	}

	/**
	 * 指定されたバイト配列を読み込み、履歴として返す。
	 *
	 * @return 履歴
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	public static Object readBytes(byte[] fn) {
		try {
			ByteArrayInputStream fis = new ByteArrayInputStream(fn);
			ObjectInputStream oout = new ObjectInputStream(fis);
			Object o = oout.readObject();
			fis.close();
			return o;
		} catch (Exception e) {
			return null;
		}
	}
}
