package jp.kitec.lib.gui.event;


/**
 * メッセージ受信インターフェイス。<BR>
 *
 * @since 　2003/03/01
 * @author　Kawae
 * @version 2003/03/01
 *
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
 */
public interface ActionContainer {

	/**
	 * このオブジェクトで発生したイベントの処理。
	 *
	 * @param ai
	 * @since   2003/03/01
	 * @author  Kawae
	 * @version 2003/03/01
	 */
	public void actionperform(ActionItem ai);

	/**
	 * フォーカスを取得したときのイベントの処理。
	 *
	 * @param ai
	 * @since   2003/03/01
	 * @author  Kawae
	 * @version 2003/03/01
	 */
	public void actionfocus(ActionItem ai);

	/**
	 * フォーカスを喪失したときのイベントの処理。
	 *
	 * @param ai
	 * @since   2003/03/01
	 * @author  Kawae
	 * @version 2003/03/01
	 */
	public void actionlostfocus(ActionItem ai);
}