package jp.kitec.kwt;

import java.io.Serializable;


public abstract class KGradientFill implements KFill, Serializable {
	private KColor[] mColor;
	private double[] mFractions;

	protected KGradientFill(KColor[] color, double[] fractions) {
		if (color.length != fractions .length)
			throw new IllegalArgumentException();
		mColor = color;
		mFractions = fractions;
	}

	public KColor[] getColor() {
		return mColor;
	}

	public double[] getFractions() {
		return mFractions;
	}

	@Override
	public String encode() {
		StringBuilder sb = new StringBuilder();
		for (KColor c : mColor) {
			sb.append(c.encode()).append(",");
		}
		sb.append(";");
		for (double d : mFractions) {
			sb.append(d).append(",");
		}
		return sb.toString();
	}
}