/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 * @author matsuzaki
 */
/**
 *
 */
package jp.kitec.vecmath;

import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple2f;

import jp.kitec.lib.geom.K2DFigureType;
import jp.kitec.lib.geom.K2DPathFigurePoint;

/**
 * @author matsuzaki
 *
 */
public class KPoint2d extends Point2d implements K2DPathFigurePoint {

	/**
	 *
	 */
	public KPoint2d() {
		super();
	}

	/**
	 * @param x
	 * @param y
	 */
	public KPoint2d(double x, double y) {
		super(x, y);
	}

	/**
	 * @param p
	 */
	public KPoint2d(double[] p) {
		super(p);
	}

	/**
	 * @param p1
	 */
	public KPoint2d(Point2d p1) {
		super(p1);
	}

	/**
	 * @param p1
	 */
	public KPoint2d(Point2f p1) {
		super(p1);
	}

	/**
	 * @param t1
	 */
	public KPoint2d(Tuple2d t1) {
		super(t1);
	}

	/**
	 * @param t1
	 */
	public KPoint2d(Tuple2f t1) {
		super(t1);
	}

	public void setXY(double x, double y) {
		this.x = x;
		this.y = y;
	}

	public int getType() {
		return K2DFigureType.POINT;
	}

	/* (non-Javadoc)
	 * @see jp.kitec.lib.geom.K2DPathFigurePoint#setX(double)
	 */
	public void setX(double x) {
		this.x = x;
	}
	
	/* (non-Javadoc)
	 * @see jp.kitec.lib.geom.K2DPathFigurePoint#setY(double)
	 */
	public void setY(double y) {
		this.y = y;
	}
	
	/* (non-Javadoc)
	 * @see jp.kitec.lib.geom.K2DPathFigurePoint#getX()
	 */
	public double getX() {
		return this.x;
	}
	
	/* (non-Javadoc)
	 * @see jp.kitec.lib.geom.K2DPathFigurePoint#getY()
	 */
	public double getY() {
		return this.y;
	}
}
