/*
 * Copyright (c) 2008 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;



/**
 * 格納オブジェクトが一意であることを保証する{@link List}。
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class ListUniqueDecorator<E> implements List<E>, Serializable {

	private List<E> mList = null;

	public ListUniqueDecorator(List<E> list) {
		super();
		this.mList = list;
	}

	public void add(int index, E element) {
		if (this.contains(element)) return;
		this.mList.add(index, element);
	}

	public boolean add(E o) {
		if (this.contains(o)) return false;
		return this.mList.add(o);
	}

	public boolean addAll(Collection<? extends E> c) {
		boolean result = false;
		if (c == null) return result;

		for (E element: c) {
			if (this.mList.contains(element)) continue;
			this.mList.add(element);
			result = true;
		}
		return result;
	}

	public boolean addAll(int index, Collection<? extends E> c) {
		return this.mList.addAll(index, c);
	}

	public void clear() { this.mList.clear(); }
	public boolean contains(Object o) { return this.mList.contains(o); }
	public boolean containsAll(Collection<?> c) { return this.mList.containsAll(c); }
	@Override
	public boolean equals(Object o) { return this.mList.equals(o); }
	public E get(int index) { return this.mList.get(index); }
	@Override
	public int hashCode() { return this.mList.hashCode(); }
	public int indexOf(Object o) { return this.mList.indexOf(o); }
	public boolean isEmpty() { return this.mList.isEmpty(); }
	public Iterator<E> iterator() { return this.mList.iterator(); }
	public int lastIndexOf(Object o) { return this.mList.lastIndexOf(o); }
	public ListIterator<E> listIterator() { return this.mList.listIterator(); }
	public ListIterator<E> listIterator(int index) { return this.mList.listIterator(index); }
	public E remove(int index) { return this.mList.remove(index); }
	public boolean remove(Object o) { return this.mList.remove(o); }
	public boolean removeAll(Collection<?> c) { return this.mList.removeAll(c); }
	public boolean retainAll(Collection<?> c) { return this.mList.retainAll(c); }
	public E set(int index, E element) { return this.mList.set(index, element); }
	public int size() { return this.mList.size(); }
	public List<E> subList(int fromIndex, int toIndex) { return this.mList.subList(fromIndex, toIndex); }
	public Object[] toArray() { return this.mList.toArray(); }
	public <T> T[] toArray(T[] a) { return this.mList.toArray(a); }



} // end-interface
