/*
 * Copyright (c) 2007 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * デバッグユーティリティクラス
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class DebugUtil {

	//------------------------------------------------------------------
	//- fields
	//------------------------------------------------------------------

	/** ログ */
	private static final Log _log = LogFactory.getLog(DebugUtil.class);



	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ（外部new禁止）
	 */
	protected DebugUtil() {
	}



	//-----------------------------------------------------------------------
	//- methods
	//-----------------------------------------------------------------------

	/**
	 * StackTraceの内容をStringに変換します
	 *
	 * @param src Throwableオブジェクト
	 * @return Stringに変換されたStackTrace
	 */
	public static String getStackTrace(Throwable src) {
		String dst = null;

		ByteArrayOutputStream os = null;
		PrintWriter pw = null;
		try {
			os = new ByteArrayOutputStream();
			pw = new PrintWriter(os);
			src.printStackTrace(pw);
			pw.flush();
			os.flush();
			dst = os.toString();
		} catch (Throwable tw) {
			dst = tw.toString();
		} finally {
			try {
				if (pw != null) pw.close();
			} finally {
				try {
					if (os != null) os.close();
				} catch (Throwable tw) {
					dst = tw.toString();
				}
			}
			pw = null;
			os = null;
		}

		return dst;
	}

	/**
	 * コレクションの文字列表現を取得します。<br/>
	 *
	 * @param collection java.util.Collectionの実装クラス
	 * @return コレクションの文字列表現
	 */
	public static String toString(Collection collection) {
		return toString(collection, false);
	}

	/**
	 * コレクションの文字列表現を取得します。<br/>
	 *
	 * @param collection java.util.Collectionの実装クラス
	 * @param deep trueの場合、取り出したオブジェクトへ再帰処理を行います。
	 * @return コレクションの文字列表現
	 */
	public static String toString(Collection collection, boolean deep) {
		if (collection == null) return null;

		StringBuffer sb = new StringBuffer();
		for (Iterator ite = collection.iterator(); ite.hasNext(); ) {
			Object value = ite.next();
			if (value == null) continue;
			String str = null;
			if (deep) {
				if (value instanceof Collection)
					str = toString((Collection)value, deep);
				else if (value instanceof Map)
					str = toString((Map)value, deep);
				else
					str = value.toString() + "\n";
			} else
				str = value.toString() + "\n";
			sb.append(str);
		}
		return sb.toString();
	}

	/**
	 * Mapの文字列表現を取得します。<br/>
	 *
	 * @param collection java.util.Mapの実装クラス
	 * @return Mapの文字列表現
	 */
	public static String toString(Map map) {
		return toString(map, false);
	}

	/**
	 * Mapの文字列表現を取得します。<br/>
	 *
	 * @param collection java.util.Mapの実装クラス
	 * @param deep trueの場合、取り出したオブジェクトへ再帰処理を行います。
	 * @return Mapの文字列表現
	 */
	public static String toString(Map<?, ?> map, boolean deep) {
		if (map == null) return null;

		StringBuffer sb = new StringBuffer();
		for (Map.Entry<?, ?> entry :  map.entrySet()) {
			Object key = entry.getKey();
			Object value = entry.getValue();
			if (value == null) continue;
			String str = null;
			if (deep) {
				if (value instanceof Collection)
					str = toString((Collection)value, deep);
				else if (value instanceof Map)
					str = toString((Map)value, deep);
				else
					str = key + ":"+ value.toString() + "\n";
			} else
				str = key + ":"+ value.toString() + "\n";
			sb.append(str);
		}
		return sb.toString();
	}

	/**
	 * リストの文字列表現を取得します。<br/>
	 *
	 * @param list java.util.Listの実装クラス
	 * @return リストの文字列表現
	 */
	public static String toString(List list) {
		if (list == null) return null;

		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < list.size(); i++) {
			sb.append(list.get(i) + "\n");
		}
		return sb.toString();
	}



} // end-class
