/*
 * Created on 2006/01/13
 */
package jp.kitec.lib.geom;

/**
 * ２次元点要素のインターフェース
 * 2DのPoint系は全てこれをインプリすること。
 * 
 * @author kawae
 * @since 2006/01/13
 */
public interface K2DPathFigurePoint extends K2DPathFigure {

	/**
	 * Ｘ座標値を取得する。
	 * 
	 * @return	Ｘ座標値
	 * @author kawae
	 * @since 2006/01/13
	 */
	public double getX();

	/**
	 * Ｙ座標値を取得する。
	 * 
	 * @return	Ｙ座標値
	 * @author kawae
	 * @since 2006/01/13
	 */
	public double getY();


	/**
	 * Ｘ座標値をセットする。
	 * 
	 * @param x	Ｘ座標値
	 * @author kawae
	 * @since 2006/01/13
	 */
	public void setX( double x );

	/**
	 * Ｙ座標値をセットする。
	 * 
	 * @param y	Ｙ座標値
	 * @author kawae
	 * @since 2006/01/13
	 */
	public void setY( double y );
	
	/**
	 * ＸＹ座標をセットする
	 * @param x
	 * @param y
	 * @author kawae
	 * @since 2006/01/16
	 */
	public void setXY(double x, double y);
}
