/*
 * Created on 2006/01/13
 */
package jp.kitec.lib.geom;


/**
 * ２次元円弧要素のインターフェース
 * 
 * @author kawae
 * @since 2006/01/13
 */
public interface K2DPathFigureArc extends K2DPathFigureLine {
	/**
	 * 円弧の中心点のＸ座標値を取得する。
	 * 
	 * Coded on 2005/07/22
	 * @return	円弧の中心点のＸ座標値
	 */
	public double getCX();

	/**
	 * 円弧の中心点のＹ座標値を取得する。
	 * 
	 * Coded on 2005/07/22
	 * @return	円弧の中心点のＹ座標値
	 */
	public double getCY();

	/**
	 * 円弧の半径を取得する。
	 * 
	 * Coded on 2005/07/28
	 * @return double	円弧の半径
	 */
	public double getRadius();

	/**
	 * 時計回り円弧かどうかの問い合わせをする。
	 * 
	 * Coded on 2005/07/28
	 * @return boolean	時計回りの場合true
	 */
	public boolean isCw();

	/**
	 * 円弧の中心点のＸ座標値をセットする。
	 * 
	 * Coded on 2005/07/25
	 * @param x	円弧の中心点のＸ座標値
	 */
	public void setCX( double x );

	/**
	 * 円弧の中心点のＹ座標値をセットする。
	 * 
	 * Coded on 2005/07/25
	 * @param y	円弧の中心点のＹ座標値
	 */
	public void setCY( double y );

	/**
	 * 時計回り円弧の場合trueをセットする。
	 * 
	 * Coded on 2005/07/28
	 * @param cw	時計回りの場合true
	 */
	public void setCw( boolean cw );

	/**
	 * 円弧の半径をセットする。
	 * 
	 * Coded on 2005/09/13
	 * @param radius	円弧の半径
	 */
	public void setRadius( double radius );
}
