/*
 * Copyright (c) 2010 KITec Inc,.. All rights reserved.
 * @author matsuzaki
 */
/**
 *
 */
package jp.kitec.kwt;

import java.util.List;

import jp.kitec.lib.geom.K2DPathFigureArc;
import jp.kitec.lib.geom.K2DPathFigureCurve;
import jp.kitec.lib.geom.K2DPathFigureLine;
import jp.kitec.lib.geom.K2DPathFigurePoint;
import jp.kitec.lib.geom.K2DPathFigureQuad;
import jp.kitec.lib.geom.KLocalAxis;


/**
 * @author matsuzaki
 *
 */
public abstract class MinRichGraphics implements IRichGraphics {

	public void drawPolygon(List<? extends K2DPathFigurePoint> poly, KLineType lt) {
		if (poly == null || poly.size() == 0)
			return;
		pathInit(WIND_EVEN_ODD);
		for (int i = 0; i < poly.size(); i++) {
			K2DPathFigurePoint p = poly.get(i);
			if (i == 0)
				pathMoveTo(p.getX(), p.getY(), null);
			else
				pathLineTo(p.getX(), p.getY(), null);
		}
		pathClose();
		drawPath(lt);
		pathClear();
	}

	public void drawFillPolygon(List<? extends K2DPathFigurePoint> poly, KLineType lt) {
		if (poly == null || poly.size() == 0)
			return;
		pathInit(WIND_EVEN_ODD);
		for (int i = 0; i < poly.size(); i++) {
			K2DPathFigurePoint p = poly.get(i);
			if (i == 0)
				pathMoveTo(p.getX(), p.getY(), null);
			else
				pathLineTo(p.getX(), p.getY(), null);
		}
		pathClose();
		fillPath(lt);
		pathClear();
	}

	public void drawPolyLine(List<? extends K2DPathFigurePoint> poly, KLineType lt) {
		if (poly == null || poly.size() == 0)
			return;

		pathInit(WIND_EVEN_ODD);
		for (int i = 0; i < poly.size(); i++) {
			K2DPathFigurePoint p = poly.get(i);
			if (i == 0)
				pathMoveTo(p.getX(), p.getY(), null);
			else
				pathLineTo(p.getX(), p.getY(), null);
		}
		drawPath(lt);
		pathClear();
	}

	public void pathAdd(KPathIterator shape, KLocalAxis la) {
		if (shape.isDone())
			return;
		pathInit(shape.getWindingRule());
		double[] coords = new double[6];
		for (; !shape.isDone(); shape.next()) {
			int type = shape.getSegment(coords);
			switch (type) {
			case IRichGraphics.DEF_SEG_CLOSE:
				pathClose();
				break;
			case IRichGraphics.DEF_SEG_MOVE:
				pathMoveTo(coords[0], coords[1], la);
				break;
			case IRichGraphics.DEF_SEG_LINE:
				pathLineTo(coords[0], coords[1], la);
				break;
			case IRichGraphics.DEF_SEG_QUAD:
				pathQuadTo(coords[0], coords[1], coords[2], coords[3], la);
				break;
			case IRichGraphics.DEF_SEG_CUBIC:
				pathCurveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], la);
				break;
			default:
				throw new IllegalArgumentException();
			}
		}
	}

	@Deprecated
	public void pathAdd(List<? extends K2DPathFigureLine> col, KLocalAxis la) {
		if (col.size() < 2)
			return;
		K2DPathFigureLine f1 = col.get(0);
		K2DPathFigureLine f2 = col.get(1);

		double x1, y1;
		if (
				RichGraphicsUtil.isSame2D(f1.getX1(), f1.getY1(), f2.getX1(), f2.getY1()) ||
				RichGraphicsUtil.isSame2D(f1.getX1(), f1.getY1(), f2.getX2(), f2.getY2())
		)  {
			x1 = f1.getX2();
			y1 = f1.getY2();
		} else {
			x1 = f1.getX1();
			y1 = f1.getY1();
		}
		pathMoveTo(x1, y1, la);

		for (int i = 0; i < col.size() ; i++) {
			f1 =  col.get(i);
			f2 =  col.get(i + 1);

			boolean startflip =
				RichGraphicsUtil.isSame2D(f1.getX1(), f1.getY1(), f2.getX1(), f2.getY1()) ||
				RichGraphicsUtil.isSame2D(f1.getX1(), f1.getY1(), f2.getX2(), f2.getY2());

			if (f1 instanceof K2DPathFigureArc) {
				K2DPathFigureArc arc = (K2DPathFigureArc)f1;
				double r = arc.getRadius();
				double cx = arc.getCX();
				double cy = arc.getCY();
				double p1a = RichGraphicsUtil.getAngle2D(cx, cy, arc.getX1(), arc.getY1());
				double p2a = RichGraphicsUtil.getAngle2D(cx, cy, arc.getX2(), arc.getY2());

				double angl = p2a - p1a;
				while (angl < 0)
					angl += 360;

				if (arc.isCw())
					angl = -(360 - angl);
				if (startflip)
					angl = -angl;
				pathArc(cx , cy , r, r, startflip?p2a : p1a, angl, la);
			} else if (f1 instanceof K2DPathFigureQuad) {
				K2DPathFigureQuad quad = (K2DPathFigureQuad)f1;

				if (startflip) {
					pathQuadTo(quad.getCX1(), quad.getCY1(), quad.getX1(), quad.getY1(), la);
				} else {
					pathQuadTo(quad.getCX1(), quad.getCY1(), quad.getX2(), quad.getY2(), la);
				}
			} else if (f1 instanceof K2DPathFigureCurve) {
				K2DPathFigureCurve quad = (K2DPathFigureCurve)f1;

				if (startflip) {
					pathCurveTo(quad.getCX2(), quad.getCY2(), quad.getCX1(), quad.getCY1(), quad.getX1(), quad.getY1(), la);
				} else {
					pathCurveTo(quad.getCX1(), quad.getCY1(), quad.getCX2(), quad.getCY2(), quad.getX2(), quad.getY2(), la);
				}
			} else {
				if (startflip) {
					pathLineTo(f1.getX1(), f1.getY1(), la);
				} else {
					pathLineTo(f1.getX2(), f1.getY2(), la);
				}
			}
		}
	}

	/**
	 * 円弧パスの追加
	 * anglが負の場合は時計回り。
	 *
	 * @param xc
	 * @param yc
	 * @param ra
	 * @param ss
	 * @param ee
	 * @param la
	 * @author kawae
	 * @since 2006/01/18
	 */
	public void pathArc(double xc, double yc, double ra, double startangl,
			double angl, KLocalAxis la) {
		pathArc(xc , yc , ra, ra, startangl, angl, la);
	}

	protected void pathArc(double cx, double cy, double r, double h,
			double startAngle, double arcAngle, KLocalAxis la) {
		double div = 4;
		final double ath = arcAngle * Math.PI / 180.0;
		final double theta = ath / div;
		final double cos = Math.cos(theta);
		final double sin = Math.sin(theta);

		double[] x = new double[4];
		double[] y = new double[4];
		x[0] = x[1] = 1.0;
		y[0] = 0.0;
		x[3] = cos;
		y[3] = sin;
		x[2] = (8.0 * Math.cos(theta / 2) - (x[0] + 3 * x[1] + x[3])) / 3;
		y[2] = y[3] - (-x[2] + x[3]) / (-Math.tan(theta));
		y[1] = (8.0 * Math.sin(theta / 2) - (y[0] + 3 * y[2] + y[3])) / 3;

		final double stheta = startAngle * Math.PI / 180.0;
		final double scos = Math.cos(stheta);
		final double ssin = Math.sin(stheta);
		for (int j = 0; j < 4; j++) {
			double xtmp = x[j] * scos - y[j] * ssin;
			double ytmp = x[j] * ssin + y[j] * scos;
			x[j] = xtmp;
			y[j] = ytmp;
		}

		pathMoveTo(r * x[0] + cx, h * y[0] + cy, la);
		for (int i = 0; i < div; i++) {
			pathCurveTo(
					r * x[1] + cx, h * y[1] + cy,
					r * x[2] + cx, h * y[2] + cy,
					r * x[3] + cx, h * y[3] + cy,
					la);
			for (int j = 1; j < 4; j++) {
				double xtmp = x[j] * cos - y[j] * sin;
				double ytmp = x[j] * sin + y[j] * cos;
				x[j] = xtmp;
				y[j] = ytmp;
			}
		}
	}
}
