package jp.kitec.lib.util.xml;

import java.io.InputStream;

import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.util.tree.ObjectFolder;



/**
 * XML 管理クラス。
 *
 * @since		2004/05/18
 * @author		fujita
 * @version	2004/05/18
 *
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
 */
public class XMLManager {
	public static final String[] ENC_64_CHARS = {"<", ">", "\""};
//	public static final String ENC_64_TAG = "__BASE64_ENCODED_TEXT__";
	public static final String BASE64_TAG_BRGIN = "__BEGIN_BASE64ENCODED__";
	public static final String BASE64_TAG_END = "__END_BASE64ENCODED__";
//	public static final String ENC_64_TAG = "__BASE64_ENCODED_TEXT__";

	/** XML ファイルからの読み込みデータ（木構造） */
	private ObjectFolder mObjFolder;


	/**
	 * 指定された in からXML データを読み込む。
	 *
	 * @param		in	XML データ入力オブジェクト
	 * @return		XML データを正しく読み込めた場合、true。
	 * 				そうでない場合は、false
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	public boolean load(AbstFile in) {
		XMLParser xml = new XMLParser();
		mObjFolder    = xml.load(in);

		return (mObjFolder != null) ? true : false;
	}

	public boolean load(AbstFile in, String encode) {
		XMLParser xml = new XMLParser();
		mObjFolder    = xml.load(in, encode);

		return (mObjFolder != null) ? true : false;
	}

	/**
	 * 指定された in からXML データを読み込む。
	 *
	 * @param		in	XML データ入力ストリーム
	 * @return		XML データを正しく読み込めた場合、true。
	 * 				そうでない場合は、false
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	public boolean load(InputStream in) {
		XMLParser xml = new XMLParser();
		mObjFolder    = xml.load(in);
		return (mObjFolder != null) ? true : false;
	}

	/**
	 * 指定された file からXML データを読み込む。
	 *
	 * @param		file	XML データ入力ファイル（名）
	 * @return		XML データを正しく読み込めた場合、true。
	 * 				そうでない場合は、false
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	public boolean load(String file) {
		XMLParser xml = new XMLParser();
		mObjFolder    = xml.load(file);
		return (mObjFolder != null) ? true : false;
	}

	/**
	 * XML を表す木構造のデータを返す。
	 *
	 * @return		木構造データ
	 * @since		2004/05/19
	 * @author		fujita
	 * @version	2004/05/19
	 */
	public ObjectFolder getTree() {
		return mObjFolder;
	}
}