/*
 * Copyright (c) 2008 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;



/**
 * 格納オブジェクトがnullでないことを保証する{@link Set}。
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class SetNotNullDecorator<E> implements Set<E>, Serializable {

	private Set<E> mSet = null;

	public SetNotNullDecorator(Set<E> set) {
		super();
		this.mSet = set;
	}

	public boolean add(E o) {
		if (o == null) return false;
		return this.mSet.add(o);
	}

	public boolean addAll(Collection<? extends E> c) {
		boolean result = false;
		for (E element: c) {
			if (element == null) continue;
			this.mSet.add(element);
			result = true;
		}
		return result;
	}

	public void clear() { this.mSet.clear(); }
	public boolean contains(Object o) { return this.mSet.contains(o); }
	public boolean containsAll(Collection<?> c) { return this.mSet.containsAll(c); }
	@Override
	public boolean equals(Object o) { return this.mSet.equals(o); }
	@Override
	public int hashCode() { return this.mSet.hashCode(); }
	public boolean isEmpty() { return this.mSet.isEmpty(); }
	public Iterator<E> iterator() { return this.mSet.iterator(); }
	public boolean remove(Object o) { return this.mSet.remove(o); }
	public boolean removeAll(Collection<?> c) { return this.mSet.removeAll(c); }
	public boolean retainAll(Collection<?> c) { return this.mSet.retainAll(c); }
	public int size() { return this.mSet.size(); }
	public Object[] toArray() { return this.mSet.toArray(); }
	public <T> T[] toArray(T[] a) { return this.mSet.toArray(a); }



} // end-interface
