/*
 * Copyright (c) 2009-2010 KITec Inc,.. All rights reserved.
 */
package jp.kitec.lib.util;




/**
 * 名称に関するユーティリティクラス
 *
 * @author $Author$
 * @version $Revision$ $Date::                           $
 */
public class NameUtil {

	//------------------------------------------------------------------
	//- constructors
	//------------------------------------------------------------------

	/**
	 * コンストラクタ
	 */
	protected NameUtil() {
		super();
	}



	//------------------------------------------------------------------
	//- methods
	//------------------------------------------------------------------

	/**
	 * 名称の接頭辞を取り除く。<br/>
	 * 'm', '_'を接頭辞として取り除く。<br/>
	 *
	 * @param name 名称
	 * @return 加工された名称
	 */
	public static String removePrefix(String name) {
		char[] prefixs = new char[] {'m', '_'};

		String newName = name;
		for (char prefix: prefixs) {
			String work = removePrefix(name, prefix);
			if (!name.equals(work)) {
				newName = work;
				break;
			}
		}

		return newName;
	}

	/**
	 * 名称の接頭辞を取り除く。
	 *
	 * @param name 名称
	 * @param prefix 接頭辞
	 * @return 加工された名称
	 */
	public static String removePrefix(String name, char prefix) {
		if (name.length() < 2) return name;
		if (name.charAt(0) != prefix) return name;
		if (!CharChecker.hasCharacter(name.charAt(1), CharChecker.ASCII_CAPITAL_ALPHABET)) return name;

		StringBuilder newNameBuf = new StringBuilder(name);
		newNameBuf.deleteCharAt(0);
		return newNameBuf.toString();
	}

	/**
	 * 名称に接頭辞を追加する。<br/>
	 * 先頭文字が小文字の場合、大文字に変換後、接頭辞を追加する。<br/>
	 *
	 * @param name 名称
	 * @param prefix 接頭辞
	 * @return 加工された名称
	 */
	public static String addPrefix(String name, char prefix) {
		StringBuilder newNameBuf = new StringBuilder(name);
		if (CharChecker.hasCharacter(newNameBuf.charAt(0), CharChecker.ASCII_SMALL_ALPHABET)) {
			char first = Character.toUpperCase(newNameBuf.charAt(0));
			newNameBuf.setCharAt(0, first);
		}
		newNameBuf.insert(0, prefix);
		return newNameBuf.toString();
	}

	/**
	 * キャメルケースに矯正する。
	 *
	 * @param name 名称
	 * @return 加工された名称
	 */
	public static String correctCamelCase(String name) {
		if (CharChecker.hasCharacter(name.charAt(0), CharChecker.ASCII_SMALL_ALPHABET)) return name;
		StringBuilder newNameBuf = new StringBuilder(name);

		int capitalCount = 0;
		for (int i = 0; i < newNameBuf.length(); i++) {
			if (CharChecker.hasCharacter(newNameBuf.charAt(i), CharChecker.ASCII_CAPITAL_ALPHABET)) capitalCount++;
		}
		if (capitalCount > 1) capitalCount--;

		for (int i = 0; i < capitalCount; i++) {
			char chr = Character.toLowerCase(newNameBuf.charAt(i));
			newNameBuf.setCharAt(i, chr);
		}

		return newNameBuf.toString();
	}



} // end-class
