package jp.kitec.lib.util;

import java.io.Serializable;


/**
 * リスト中のアイテム。<BR>
 * 自身の前後のアイテムを保持する。<BR> 
 * 
 * @since 　2002/12/20
 * @author　Kawae
 * @version 2002/12/20
 * 
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
 */
public class Item<E> implements Serializable {
	
	/////////////////////////////////////////////////////////////////////////
	// フィールド
	
	/** このアイテムの次のアイテム */
	public Item<E> nextItem;
	
	/** このアイテムの前のアイテム */
	public Item<E> prevItem;

	/** このアイテムと関連（所有）するデータ */
	private E _object;


	/**
	 * 指定されたデータを持ち、前後のアイテムのない（=null）の
	 * 新たなアイテムを作成する。
	 * 
	 * @param i	データ
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	public Item(E i) {
		setObject(i);
		nextItem = prevItem = null;
	}

	/**
	 * このアイテムが保持するデータ返す。
	 * 
	 * @return	データ
	 * @see #setObject(Object)
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	public E getObject() {
		 return _object;
	}

	/**
	 * 指定されたデータを、このアイテムのデータとして設定する。
	 * 
	 * @param o	データ
	 * @see #getObject()
	 * @since   2002/12/20
	 * @author  Kawae
	 * @version 2002/12/20
	 */
	public void setObject(E o) {
		_object = o;
	}
}