package jp.kitec.lib.io;

import java.io.File;

import jp.kitec.lib.util.tree.ObjectFolder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * @author kawae
 */
public class FileSystemIO {

	private static final Log log = LogFactory.getLog(FileSystemIO.class);

	/**
	 * ファイルシステムへファイルの追加
	 * @param targetPath	対象の基本フォルダからのファイルパス
	 * @param cachefile		ファイルをキャッシュするか
	 */
	public static void addFileSystem(FileSystem fs, String targetPath, boolean cachefile, String[] exts) {
		if (targetPath.indexOf("\\") >= 0)
			targetPath = targetPath.replace('\\', FileSystem.SEPARATOR);
		//フォルダ下モードの場合
		if (targetPath.equalsIgnoreCase("*")) {
			File f =  new File(fs.mBaseDir);
			if (f.isDirectory()) {
				String[] files = f.list();
				for (int i = 0; i < files.length; i++) {
					addFileSystem(fs, files[i], fs.mRootFolder, cachefile, exts);
				}
			}
		} else {
			addFileSystem(fs, targetPath, fs.mRootFolder, cachefile, exts);
		}
	}


	/**
	 * ファイルシステムへノードを追加
	 *
	 * @param file			キャッシュ対象ファイル
	 * @param folder		追加先フォルダ
	 * @param cachefile		ファイルをキャッシュするか
	 */
	private static void addFileSystem(FileSystem fs, String path, ObjectFolder folder, boolean cachefile, String[] exts) {

		File file = new File(fs.mBaseDir, path);

		if (file.isDirectory()) {
			folder = FileSystem.getFolder(folder, file.getName());
			String[] files = file.list();
			for (int i = 0; i < files.length; i++) {
				ObjectFolder targetFolder = folder;
				addFileSystem(fs, path + FileSystem.SEPARATOR + files[i], targetFolder, cachefile, exts);
			}
		} else {
			//拡張子による制限
			if (exts != null) {
				if (!isMatchExtention(file.getName(), exts))
					return;
			}
			byte[] filedata = null;
			if (file.exists() && cachefile) {
				try {
					if (log.isTraceEnabled())
						log.trace("add" + file.getAbsolutePath());

					filedata = FileIOUtil.fileToBytes(file);
				} catch (Exception e) {
					filedata = null;
				}
			}
			fs.addFile(path, filedata);
		}
	}

	/**
	 * 拡張子が一致するか確認
	 * @param s
	 * @param exts
	 * @return
	 */
	private static boolean isMatchExtention(String s, String[] exts) {
		int index = s.lastIndexOf('.');
		if (index >= 0 && s.length() - 1 > index) {
			String ext = s.substring(s.lastIndexOf('.') + 1);
			//            boolean hit = false;
			for (int i = 0; i < exts.length; i++) {
				if (exts[i] != null && exts[i].equalsIgnoreCase(ext)) {
					return true;
				}
			}
		}
		return false;
	}
}
