/**
 *
 */
package jp.kitec.lib.geom;

import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KArea;

/**
 * 
 * @since 2007/10/12
 * @author kamimura
 * @version 2007/10/12
 */
public class KPathCubic2d extends KPath2d {
	/** 制御点1 */
	protected double mCX1, mCY1;

	/** 制御点2 */
	protected double mCX2, mCY2;

	/**
	 * コンストラクタ.
	 * 
	 * @since 2007/10/12
	 * @author kamimura
	 */
	public KPathCubic2d() {
	}

	@Override
	public int getType() {
		return IRichGraphics.DEF_SEG_CUBIC;
	}

	@Override
	public int getNumberSize() {
		return 6;
	}

	/*
	 * @see nethome.geom.primitive.GPath2df#getX(float, double)
	 * 
	 * @since 2007/10/15
	 */
	public double getX(double x1, double t) {
		double s = 1 - t;
		double s2 = s * s;
		double t2 = t * t;
		return s2 * (s * x1 + 3 * t * mCX1) + t2 * (3 * s * mCX2 + t * mX1);
	}

	/*
	 * @see nethome.geom.primitive.GPath2df#getY(float, double)
	 * 
	 * @since 2007/10/15
	 */
	public double getY(double y1, double t) {
		double s = 1 - t;
		double s2 = s * s;
		double t2 = t * t;
		return s2 * (s * y1 + 3 * t * mCY1) + t2 * (3 * s * mCY2 + t * mY1);
	}

	/*
	 * @see
	 * nethome.geom.primitive.GPath2df#appendPath(jp.kitec.kwt.IRichGraphics,
	 * nethome.geom.LocalAxis2Df, nethome.geom.primitive.GPathShape)
	 * 
	 * @since 2007/10/12
	 */
	@Override
	public void appendPath(IRichGraphics d, KLocalAxis la, KLocalAxis la2) {
		if (la == null) {
			d.pathCurveTo(mCX1, mCY1, mCX2, mCY2, mX1, mY1, la2);
		} else {
			double cx1 = la.getGlobalX(mCX1, mCY1);
			double cy1 = la.getGlobalY(mCX1, mCY1);
			double cx2 = la.getGlobalX(mCX2, mCY2);
			double cy2 = la.getGlobalY(mCX2, mCY2);
			double mx1 = la.getGlobalX(mX1, mY1);
			double my1 = la.getGlobalY(mX1, mY1);
			d.pathCurveTo(cx1, cy1, cx2, cy2, mx1, my1, la2);
		}
	}

	/*
	 * @see nethome.geom.primitive.GPath2df#getPoints(double[])
	 * 
	 * @since 2007/10/12
	 */
	@Override
	public void getPoints(double[] points) {
		points[0] = this.mCX1;
		points[1] = this.mCY1;
		points[2] = this.mCX2;
		points[3] = this.mCY2;
		points[4] = this.mX1;
		points[5] = this.mY1;
	}

	/*
	 * @see nethome.geom.primitive.GPath2df#updateMinMax(jp.kitec.kwt.Area,
	 * double, double)
	 * 
	 * @since 2007/10/12
	 */
	@Override
	public void updateMinMax(KArea area, double x1, double y1) {

		double a, b, c;

		// x側
		a = -x1 + 3 * mCX1 - 3 * mCX2 + mX1;
		b = +3 * x1 - 6 * mCX1 + 3 * mCX2;
		c = -3 * x1 + 3 * mCX1;

		if (a != 0) {// 3次
			double a2 = 3 * a;
			double b2 = 2 * b;
			double c2 = c;
			double D2 = b2 * b2 - 4 * a2 * c2;
			if (D2 > 0) {
				D2 = Math.sqrt(D2);
				double p1 = (-b2 + D2) / (a2 * 2);
				double p2 = (-b2 - D2) / (a2 * 2);
				if (0 <= p1 && p1 <= 1) {
					area.updateMinMax(getX(x1, p1), getY(y1, p1));
				}
				if (0 <= p2 && p2 <= 1) {
					area.updateMinMax(getX(x1, p2), getY(y1, p2));
				}
			}
		} else {
			if (b != 0) {// 2次
				double cx = -c / (2 * b);
				if (0 <= cx && cx <= 1) {
					area.updateMinMax(getX(x1, cx), getY(y1, cx));
				}
			}
		}

		/////////////////////////////////////////////

		a = -y1 + 3 * mCY1 - 3 * mCY2 + mY1;
		b = +3 * y1 - 6 * mCY1 + 3 * mCY2;
		c = -3 * y1 + 3 * mCY1;

		if (a != 0) {// 3次
			double a2 = 3 * a;
			double b2 = 2 * b;
			double c2 = c;
			double D2 = b2 * b2 - 4 * a2 * c2;
			if (D2 > 0) {
				D2 = Math.sqrt(D2);
				double p1 = (-b2 + D2) / (a2 * 2);
				double p2 = (-b2 - D2) / (a2 * 2);
				if (0 <= p1 && p1 <= 1) {
					area.updateMinMax(getX(x1, p1), getY(y1, p1));
				}
				if (0 <= p2 && p2 <= 1) {
					area.updateMinMax(getX(x1, p2), getY(y1, p2));
				}
			}
		} else {
			if (b != 0) {// 2次
				double cx = -c / (2 * b);
				if (0 <= cx && cx <= 1) {
					area.updateMinMax(getX(x1, cx), getY(y1, cx));
				}
			}
		}

		area.updateMinMax(x1, y1);
		area.updateMinMax(mX1, mY1);
	}
}
