/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.kwt.KMouseEvent;
import jp.kitec.lib.kwt.KPopupMenu;
import jp.kitec.lib.util.UtilString;
import jp.kitec.richui.KTabItem;

public class KTabView
extends Panel
implements MouseListener,
ActionListener,
FocusListener {
    protected Vector<KTabItem> mItems;
    private int mOfsX = 0;
    protected KPopupMenu mPopup;
    protected KTabItem mCurrentHit;
    protected boolean mDispPop = false;
    protected boolean mTabDir;
    private Color mBackColor;
    private Dimension mDimension;

    public KTabView(boolean tabdir, Color back) {
        this.mBackColor = back;
        this.setBackground(back);
        this.mPopup = new KPopupMenu();
        this.add(this.mPopup);
        this.mItems = new Vector();
        this.mTabDir = tabdir;
        this.mBackColor = back;
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    public void addTab(String s) {
        this.addTab(s, Color.white, Color.lightGray);
    }

    public void addTab(String s, Color actColor, Color deactColor) {
        KTabItem ti = new KTabItem(s, KFont.getFont((String)"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", (int)0, (double)12.0), actColor, deactColor, this.mTabDir);
        this.setBackground(Color.lightGray);
        this.mItems.addElement(ti);
    }

    public void left() {
        int w;
        Dimension d = this.getSize();
        int maxx = -2147483647;
        int minx = Integer.MAX_VALUE;
        KTabItem first = null;
        int i = 0;
        while (i < this.mItems.size()) {
            KTabItem ti = this.mItems.elementAt(i);
            if (first == null && ti.getBound().x >= 0) {
                first = ti;
            }
            int max = ti.getBound().x + ti.getBound().width + KTabItem.SPACE;
            int min = ti.getBound().x - KTabItem.SPACE;
            maxx = max > maxx ? max : maxx;
            minx = min < minx ? min : minx;
            ++i;
        }
        int index = this.mItems.indexOf(first);
        if (this.mItems.size() > index + 1) {
            first = this.mItems.elementAt(index + 1);
        }
        this.mOfsX = (w = maxx - minx) < d.width ? 0 : (maxx - first.getBound().width > d.width ? -(first.getBound().x - minx - KTabItem.SPACE) : d.width - w - 1);
        this.update();
        this.updatePos();
        this.repaint();
    }

    public void right() {
        int index;
        Dimension d = this.getSize();
        int maxx = -2147483647;
        int minx = Integer.MAX_VALUE;
        KTabItem first = null;
        int i = 0;
        while (i < this.mItems.size()) {
            KTabItem ti = this.mItems.elementAt(i);
            if (first == null && ti.getBound().x - KTabItem.SPACE >= 0) {
                first = ti;
            }
            int max = ti.getBound().x + ti.getBound().width + KTabItem.SPACE;
            int min = ti.getBound().x - KTabItem.SPACE;
            maxx = max > maxx ? max : maxx;
            minx = min < minx ? min : minx;
            ++i;
        }
        int w = maxx - minx;
        if (w < d.width) {
            this.mOfsX = 0;
        }
        if ((index = this.mItems.indexOf(first)) > 0) {
            first = this.mItems.elementAt(index - 1);
        }
        this.mOfsX = maxx - first.getBound().width > 0 ? -(first.getBound().x - minx - KTabItem.SPACE) : 0;
        this.update();
        this.updatePos();
        this.repaint();
    }

    public void updatePos() {
        Dimension d = this.getSize();
        int maxx = -2147483647;
        int minx = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.mItems.size()) {
            KTabItem ti = this.mItems.elementAt(i);
            int max = ti.getBound().x + ti.getBound().width + KTabItem.SPACE;
            int min = ti.getBound().x - KTabItem.SPACE;
            maxx = max > maxx ? max : maxx;
            minx = min < minx ? min : minx;
            ++i;
        }
        int w = maxx - minx;
        if (w < d.width) {
            this.mOfsX = 0;
        }
    }

    public void update() {
        if (this.isUpdate()) {
            this.create();
        }
        Dimension d = this.getSize();
        int x = KTabItem.SPACE;
        int i = 0;
        while (i < this.mItems.size()) {
            KTabItem ti = this.mItems.elementAt(i);
            ti.updateBound();
            ti.getBound().x = this.mOfsX + x;
            ti.getBound().height = d.height - KTabItem.SPACE / 2;
            x += ti.getBound().width;
            ti.getBound().y = this.mTabDir ? d.height - ti.getBound().height : 0;
            ++i;
        }
    }

    @Override
    public void update(Graphics g) {
        KTabItem ti;
        Dimension d = this.getSize();
        if (this.mDimension == null || this.mDimension.width != d.width || this.mDimension.height != d.height) {
            this.mDimension = d;
            this.update();
        }
        g.setColor(this.mBackColor);
        g.fillRect(0, 0, d.width, d.height);
        int i = 0;
        while (i < this.mItems.size()) {
            ti = this.mItems.elementAt(i);
            if (!ti.isActive()) {
                ti.paint(g);
            }
            ++i;
        }
        this.drawBorder(g);
        i = 0;
        while (i < this.mItems.size()) {
            ti = this.mItems.elementAt(i);
            if (ti.isActive()) {
                ti.paint(g);
            }
            ++i;
        }
    }

    protected void drawBorder(Graphics g) {
        g.setColor(Color.gray);
        Dimension d = this.getSize();
        if (this.mTabDir) {
            g.drawLine(0, d.height - 1, this.getSize().width, d.height - 1);
        } else {
            g.drawLine(0, 0, this.getSize().width, 0);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = 180;
        return d;
    }

    public KTabItem getActiveTabItem() {
        int i = 0;
        while (i < this.mItems.size()) {
            KTabItem ti = this.mItems.elementAt(i);
            if (ti.isActive()) {
                return ti;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.updateHitTab(e.getX(), e.getY());
        if (!KMouseEvent.isRightButtonMask((int)e.getModifiers())) {
            this.mDispPop = false;
        }
        if (KMouseEvent.isRightButtonMask((int)e.getModifiers())) {
            if (!this.mDispPop) {
                this.createContext();
                if (this.mPopup.getItemCount() != 0) {
                    this.mDispPop = true;
                    this.goPop(e);
                }
            }
            return;
        }
        if (this.mCurrentHit != null && !this.mCurrentHit.isActive()) {
            this.select(this.mCurrentHit.getName());
            this.update();
            this.select();
        }
        this.repaint();
    }

    protected void updateHitTab(int x, int y) {
        KTabItem ti;
        this.mCurrentHit = null;
        int i = 0;
        while (i < this.mItems.size()) {
            ti = this.mItems.elementAt(i);
            if (ti.isActive() && ti.isInner(x, y)) {
                this.mCurrentHit = ti;
                break;
            }
            ++i;
        }
        if (this.mCurrentHit == null) {
            i = 0;
            while (i < this.mItems.size()) {
                ti = this.mItems.elementAt(i);
                if (!ti.isActive() && ti.isInner(x, y)) {
                    this.mCurrentHit = ti;
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void select(String s) {
        int i = 0;
        while (i < this.mItems.size()) {
            KTabItem ti = this.mItems.elementAt(i);
            if (!UtilString.isDiff((String)s, (String)ti.getName())) {
                ti.setActive(true);
            } else {
                ti.setActive(false);
            }
            ++i;
        }
    }

    protected void createContext() {
    }

    private synchronized void goPop(MouseEvent e) {
        this.mPopup.show(this, e.getX(), e.getY());
    }

    protected void select() {
    }

    protected boolean isUpdate() {
        return false;
    }

    protected void create() {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.mDispPop = false;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.mDispPop = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

