/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

public class ImagePanel
extends Panel {
    public static final short DISP_NW = 0;
    public static final short DISP_NE = 1;
    public Image mImage;
    public int mWidth;
    public int mHeight;
    private int mDispPos;

    public ImagePanel() {
        this.mDispPos = 0;
    }

    public void setDispPos(short i) {
        this.mDispPos = i;
    }

    public ImagePanel(Image img, Container observer) {
        this.setImage(img, img.getWidth(observer), img.getHeight(observer));
    }

    public ImagePanel(Image img, int w, int h) {
        this.setImage(img, w, h);
    }

    public void setImage(Image img, int w, int h) {
        this.mImage = img;
        this.mWidth = w;
        this.mHeight = h;
    }

    @Override
    public void update(Graphics g) {
        if (this.mImage != null) {
            switch (this.mDispPos) {
                case 0: {
                    g.drawImage(this.mImage, 0, 0, null);
                    break;
                }
                case 1: {
                    Dimension d = this.getSize();
                    g.drawImage(this.mImage, d.width - this.mWidth, 0, null);
                }
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.isVisible()) {
            d.width = this.mWidth;
            d.height = this.mHeight;
        } else {
            d.width = 0;
            d.height = 0;
        }
        return d;
    }
}

