/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.kwt.KFontMetrics;
import jp.kitec.lib.kwt.KRuntime;

public class GroupBox2
extends Panel {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final int MARGIN = 2;
    private String mTitle;
    private int mAlign = 0;
    private Insets mIns = new Insets(2, 2, 2, 2);
    private Color mTextColor;
    private Color mLineDark;
    private Color mLineLight;
    private Color mLineColor;
    private Color mLineShadow;

    public GroupBox2(Component comp, String title) {
        this.mTitle = title;
        this.setLayout(new BorderLayout());
        this.add(comp, "Center");
        this.mLineLight = SystemColor.controlLtHighlight;
        this.mLineDark = SystemColor.controlShadow;
        this.mLineColor = SystemColor.controlLtHighlight;
        this.mLineShadow = SystemColor.controlShadow;
    }

    public GroupBox2(Component comp, String title, int align) {
        this(comp, title);
        this.mAlign = align;
    }

    public void setColor(Color text, Color line) {
        this.mTextColor = text;
        this.setForeground(this.mTextColor);
        this.mLineLight = line.brighter();
        this.mLineDark = line.darker();
    }

    public void setInsets(Insets ins) {
        if (ins != null) {
            this.mIns = ins;
        }
    }

    @Override
    public Insets getInsets() {
        Graphics g = this.getGraphics();
        int top = g.getFont().getSize();
        if (top > this.mIns.top) {
            this.mIns.top = top;
        }
        g.dispose();
        return new Insets(this.mIns.top, this.mIns.left, this.mIns.bottom, this.mIns.right);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.drawBorder(g);
        this.drawTitle(g);
    }

    public void drawBorder(Graphics g) {
        g.setFont(this.getFont());
        Font fm = g.getFont();
        int height = fm.getSize();
        g.setColor(this.mLineColor);
        g.setColor(this.mLineLight);
        g.drawRect(1, height / 2 + 1, this.getWidth() - 2, this.getHeight() - 2 - height / 2);
        g.drawRect(0, height / 2, this.getWidth() - 2 + 1, this.getHeight() - 2 - height / 2 + 1);
        g.setColor(this.mLineShadow);
        g.setColor(this.mLineDark);
        g.drawRect(0, height / 2, this.getWidth() - 2, this.getHeight() - 2 - height / 2);
    }

    public void drawTitle(Graphics g) {
        int x;
        int margin;
        if (this.mTitle == null || this.mTitle.length() < 1) {
            return;
        }
        KFont f = KRuntime.runtime().getFont((Object)g.getFont());
        KFontMetrics fm = f.getFontMetrics((Object)g);
        int titleWidth = (int)fm.stringWidth(this.mTitle);
        if (titleWidth + (margin = (int)fm.stringWidth("\u3042") / 2) * 2 + 2 > this.getWidth()) {
            return;
        }
        int width = titleWidth + margin * 2;
        switch (this.mAlign) {
            case 2: {
                x = this.getWidth() - titleWidth - margin * 3;
                break;
            }
            case 1: {
                x = this.getWidth() / 2 - titleWidth / 2 - margin;
                break;
            }
            default: {
                x = margin;
            }
        }
        g.setColor(this.getBackground());
        g.clearRect(x, 0, width, (int)fm.getHeight());
        g.setColor(this.getForeground());
        g.drawString(this.mTitle, x + margin, (int)fm.getAscent() - 2);
    }
}

