/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.kwt.KwtAwtConverter;
import jp.kitec.richui.AScrollPanel;
import jp.kitec.richui.CaptPanel;
import jp.kitec.richui.GButton;
import jp.kitec.richui.TipsMessage;

public class AScrollBar
extends Panel
implements ActionListener,
MouseListener,
MouseMotionListener {
    public static short MODE_VER = 0;
    public static short MODE_HOR = 1;
    public static final String MODE_DRAG = "DRAG";
    public static final String MODE_FINAL = "FINAL";
    private int mMinimum = 200;
    protected short mMode;
    private AScrollPanel mScrollBar;
    private GButton mUp;
    private GButton mDown;
    private Component mScaleComponent;
    public double height = 20.0;
    private ActionListener mActionListener;
    protected static int xw = 4;
    protected static int yw = 4;
    private double offset = 0.0;
    private double offset2 = 0.0;
    protected double mValue;
    protected double mValueMin;
    protected double mValueMax;
    protected boolean mCenterLine;
    private boolean mMouseDown;
    private String mTip = null;
    private final TipsMessage mTm;
    private CaptPanel mCaptPanel;
    private Dimension mPresSize;

    public AScrollBar(short mode, boolean centerline, boolean button, Container imageObserver, Color theme, boolean label, TipsMessage tm) {
        this(mode, centerline, button, true, imageObserver, theme, label, tm);
    }

    public AScrollBar(short mode, boolean centerline, boolean button, boolean center, Container imageObserver, Color theme, boolean label, TipsMessage tm) {
        this.mMode = mode;
        this.mMouseDown = false;
        this.mTm = tm;
        this.mPresSize = null;
        this.mCenterLine = centerline;
        if (button) {
            this.mUp = AScrollBar.createButtons(imageObserver, this.mMode, true, theme);
            this.mUp.addActionListener(this);
            this.mDown = AScrollBar.createButtons(imageObserver, this.mMode, false, theme);
            this.mDown.addActionListener(this);
        }
        if (center) {
            this.mScrollBar = new AScrollPanel(this, theme);
            this.mScrollBar.addMouseListener(this);
            this.mScrollBar.addMouseMotionListener(this);
            this.mScrollBar.mTex = AScrollBar.getTexture(imageObserver, theme, Color.white);
        }
        if (center) {
            this.setLayout(new BorderLayout());
            if (button) {
                if (mode == MODE_VER) {
                    this.add((Component)this.mUp, "North");
                    this.add((Component)this.mDown, "South");
                } else {
                    this.add((Component)this.mUp, "West");
                    this.add((Component)this.mDown, "East");
                }
            }
            this.add((Component)this.mScrollBar, "Center");
        } else if (mode == MODE_VER) {
            this.setLayout(new GridLayout(2, 1));
            this.add(this.mUp);
            this.add(this.mDown);
        } else {
            this.setLayout(new GridLayout(1, 2));
            this.add(this.mUp);
            this.add(this.mDown);
        }
        if (label) {
            KFont f = KFont.getFont((String)"Dialog", (int)0, (double)10.0);
            this.mCaptPanel = new CaptPanel(this, this.mScrollBar, f);
            this.add((Component)this.mCaptPanel, "North");
            this.mScrollBar.setCaptPanel(this.mCaptPanel);
        }
    }

    public void setPrefSize(int w, int h) {
        this.mPresSize = new Dimension(w, h);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.mCaptPanel != null) {
            this.mCaptPanel.setForeground(c);
        }
    }

    public void setMinimum(int i) {
        this.mMinimum = i;
    }

    public void setTip(String s) {
        this.mTip = s;
    }

    public GButton getUpButton() {
        return this.mUp;
    }

    public GButton getDownButton() {
        return this.mDown;
    }

    private static Image getTexture(Container observer, Color c2, Color c1) {
        Image img = observer.createImage(5, 5);
        Graphics g = img.getGraphics();
        g.setColor(c1);
        g.fillRect(0, 0, xw, yw);
        g.setColor(c2);
        for (int y = 0; y < yw; ++y) {
            int ofs = 0;
            if (y % 2 != 0) {
                ofs = 1;
            }
            for (int x = 0; x < xw; x += 2) {
                g.drawLine(x + ofs, y, x + ofs, y);
            }
        }
        g.dispose();
        return img;
    }

    public void setInterval(double val, double val2, String s) {
        if (this.mCaptPanel != null) {
            this.mCaptPanel.setInterval(val, val2, s);
            this.mCaptPanel.repaint();
        }
    }

    private static GButton createButtons(Container imageObserver, short mode, boolean dir, Color theme) {
        return AScrollBar.createButtons(imageObserver, mode, dir, theme, 17, 25);
    }

    public static GButton createButtons(Container imageObserver, short mode, boolean dir, Color theme, int sizedir, int sizever) {
        int[] yy;
        int[] xx;
        int cy;
        int cx;
        int h;
        int w;
        int l = 3;
        if (mode == MODE_VER) {
            w = sizever;
            h = sizedir;
            cx = w / 2 + w % 2;
            cy = h / 2 + h % 2;
            if (dir) {
                xx = new int[]{cx - l * 2, cx + l * 2, cx};
                yy = new int[]{cy + l, cy + l, cy - l};
            } else {
                xx = new int[]{cx - l * 2 + 1, cx, cx + l * 2 - 1};
                yy = new int[]{cy - l, cy + l - 1, cy - l};
            }
        } else {
            int[] y;
            w = sizedir;
            h = sizever;
            cx = w / 2 + w % 2;
            cy = h / 2 + h % 2;
            yy = y = new int[]{cy - l * 2, cy, cy + l * 2};
            xx = dir ? new int[]{cx + l, cx - l, cx + l} : new int[]{cx - l, cx + l, cx - l};
        }
        Image img = imageObserver.createImage(w, h);
        Graphics g = img.getGraphics();
        g.setColor(KwtAwtConverter.asAwtColor((KColor)KColor.LIGHT_GRAY2));
        g.setColor(theme);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.black);
        g.fillPolygon(xx, yy, 3);
        yy = null;
        xx = null;
        GButton b = new GButton("", img, img, img, null, theme, theme, imageObserver, null, 1);
        b.setDrawFrame(true);
        b.setPushOffset(1);
        return b;
    }

    public void update() {
        this.mScrollBar.repaint();
    }

    public void setValues(double min, double max, double val) {
        this.mValueMin = min;
        this.mValueMax = max;
        this.mValue = val;
        this.mScrollBar.repaint();
    }

    public void setScaledComponent(Component c) {
        this.mScaleComponent = c;
    }

    public void addActionListener(ActionListener l) {
        this.mActionListener = l;
    }

    public void setOffset(double f, double f2) {
        this.offset = f;
        this.offset2 = f2;
    }

    public double getValue() {
        return this.mValue;
    }

    public void inc() {
        this.mValue += this.offset;
        if (this.mValue > this.mValueMax) {
            this.mValue = this.mValueMax;
        }
    }

    public void dec() {
        this.mValue -= this.offset;
        if (this.mValue < this.mValueMin) {
            this.mValue = this.mValueMin;
        }
    }

    public void inc2() {
        this.mValue += this.offset2;
        if (this.mValue > this.mValueMax) {
            this.mValue = this.mValueMax;
        }
    }

    public void dec2() {
        this.mValue -= this.offset2;
        if (this.mValue < this.mValueMin) {
            this.mValue = this.mValueMin;
        }
    }

    public double getMaximum() {
        return this.mValueMax;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mUp) {
            this.dec2();
        } else if (e.getSource() == this.mDown) {
            this.inc2();
        }
        this.forceEvent(MODE_FINAL);
        if (this.mScrollBar != null) {
            this.mScrollBar.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.mScrollBar == null) {
            return d;
        }
        if (this.mPresSize != null && (this.mPresSize.width > 0 || this.mPresSize.height >= 0)) {
            d.width = this.mPresSize.width >= 0 ? this.mPresSize.width : d.width;
            d.height = this.mPresSize.height >= 0 ? this.mPresSize.height : d.height;
        } else if (this.mMode == MODE_HOR) {
            if (this.mScaleComponent != null) {
                d.width = this.mScaleComponent.getWidth();
            }
            d.height = (int)this.height + 6;
            if (d.width < this.mMinimum) {
                d.width = this.mMinimum;
            }
        } else {
            d.width = (int)this.height + 6;
            if (d.height < this.mMinimum) {
                d.height = this.mMinimum;
            }
        }
        return d;
    }

    public void forceEvent(String type) {
        if (this.mScrollBar != null) {
            this.mScrollBar.repaint();
        }
        this.mActionListener.actionPerformed(new ActionEvent(this, 0, type));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mScrollBar.isInController(e.getX(), e.getY())) {
            this.mMouseDown = true;
            return;
        }
        int i = this.mMode == MODE_HOR ? e.getX() : e.getY();
        if (this.mScrollBar.devToVal(i) > this.mValue) {
            this.inc();
        } else {
            this.dec();
        }
        this.forceEvent(MODE_FINAL);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mMouseDown) {
            this.forceEvent(MODE_FINAL);
        }
        this.mMouseDown = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mMouseDown) {
            this.mValue = this.mMode == MODE_HOR ? this.mScrollBar.devToVal(e.getX()) : this.mScrollBar.devToVal(e.getY());
            this.forceEvent(MODE_DRAG);
            this.mScrollBar.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.mTm != null) {
            this.mTm.setMessage(this.mTip);
            this.mTm.update();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mTm != null) {
            this.mTm.setMessage(null);
            this.mTm.update();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

