/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.kwt.KFontUtil;

public class KTabItem {
    public static int SPACE = 4;
    int[] xx = new int[]{0, 0, 0, 0};
    int[] yy = new int[]{0, 0, 0, 0};
    Polygon p;
    private boolean mActive;
    private String mName;
    private KFont mFont;
    private Rectangle mBound;
    private boolean mTabDir;
    private Color mActiveColor;
    private Color mDeActiveColor;

    public KTabItem(String name, KFont f, Color actCol, Color deActCol, boolean tabdir) {
        this.mName = name;
        this.mFont = f;
        this.mActiveColor = actCol;
        this.mDeActiveColor = deActCol;
        this.mBound = new Rectangle();
        this.mTabDir = tabdir;
        this.updateBound();
        this.p = new Polygon(this.xx, this.yy, this.xx.length);
    }

    public void updateBound() {
        this.mBound.width = (int)this.mFont.getFontMetrics((Object)this).stringWidth(this.mName) + 12;
    }

    public boolean isInner(int x, int y) {
        return this.mBound.contains(x, y);
    }

    public boolean isActive() {
        return this.mActive;
    }

    public void setActive(boolean active) {
        this.mActive = active;
    }

    public Rectangle getBound() {
        return this.mBound;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
        this.updateBound();
    }

    public void paint(Graphics g) {
        int x = this.mBound.x;
        int y = this.mBound.y;
        int w = this.mBound.width;
        int h = this.mBound.height;
        if (this.mTabDir) {
            this.p.xpoints[0] = x + w + SPACE;
            this.p.xpoints[1] = x + w - 1;
            this.p.xpoints[2] = x + 1;
            this.p.xpoints[3] = x - SPACE;
            this.p.ypoints[0] = this.p.ypoints[3] = y + h + 0;
            this.p.ypoints[1] = this.p.ypoints[2] = y + 0;
        } else {
            this.p.xpoints[0] = x - SPACE;
            this.p.xpoints[1] = x + 1;
            this.p.xpoints[2] = x + w - 1;
            this.p.xpoints[3] = x + w + SPACE;
            this.p.ypoints[0] = this.p.ypoints[3] = y;
            this.p.ypoints[1] = this.p.ypoints[2] = y + h;
        }
        if (this.mActive) {
            g.setFont(KFontUtil.getFontObject((KFont)this.mFont));
            g.setColor(this.mActiveColor);
            g.fillPolygon(this.p);
            g.setColor(Color.gray);
            for (int i = 0; i < this.xx.length - 1; ++i) {
                g.drawLine(this.p.xpoints[i], this.p.ypoints[i], this.p.xpoints[i + 1], this.p.ypoints[i + 1]);
            }
        } else {
            y = 1;
            g.setFont(KFontUtil.getFontObject((KFont)this.mFont));
            g.setColor(this.mDeActiveColor);
            g.fillPolygon(this.p);
            g.setColor(Color.gray);
            for (int i = 0; i < this.xx.length - 1; ++i) {
                g.drawLine(this.p.xpoints[i], this.p.ypoints[i], this.p.xpoints[i + 1], this.p.ypoints[i + 1]);
            }
        }
        g.setColor(Color.black);
        g.drawString(this.mName, x + 6, h - (h - (int)this.mFont.getFontMetrics((Object)g).getHeight()) / 2 - (this.mActive ? 0 : 1));
    }
}

