/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui.table;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jp.kitec.richui.table.Cell;
import jp.kitec.richui.table.CellGroup;
import jp.kitec.richui.table.Table;

public class MiddleColumnHeaderTable
extends Table {
    protected CellGroup mMiddleColumnHeaders;
    protected int[] mMiddleColumnHeadersLink;

    public MiddleColumnHeaderTable() {
    }

    public MiddleColumnHeaderTable(int[][] iUnremovableCellType) {
        super(iUnremovableCellType);
    }

    public MiddleColumnHeaderTable(boolean canScroll) {
        super(canScroll);
    }

    @Override
    public void init() {
        if (this.mMiddleColumnHeaders != null) {
            this.mMiddleColumnHeaders.removeAllCells();
        }
        this.mMiddleColumnHeadersLink = null;
        this.mColumnHeaders.removeAllCells();
        this.mCells.clear();
        this.mRowHeaders.removeAllCells();
        this.mTableWidth = 0;
        this.mTableHeight = 0;
        this.mRowHeaderWidth = 0;
        this.mRowHeight = 0;
        this.mFirstRow = 0;
        this.mTotalColumnWidth = 0;
        this.mHScrollValue = 0;
        this.mVScrollValue = 0;
        this.mColumnWidths = null;
        this.mColumnCount = 0;
        this.mRowCount = 0;
        this.mHScrollbarWidth = 0;
        this.mVScrollbarHeight = 0;
        this.mDraggedX = 0;
        this.mDraggedColumn = 0;
        this.mEditorX = 0;
        this.mEditorY = 0;
        this.mEditorWidth = 0;
        this.mSelectedRow = -1;
        this.mSelectedColumn = -1;
        this.mAutoResizeColumnWidth = true;
        this.mIsResized = true;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
        if (this.mSrlHorizontal != null) {
            this.mSrlHorizontal.setValue(0);
        }
        if (this.mSrlVertical != null) {
            this.mSrlVertical.setValue(0);
        }
    }

    @Override
    public void dispose() {
        this.disposeOffImage();
        if (this.mMiddleColumnHeaders != null) {
            this.mMiddleColumnHeaders.removeAllCells();
        }
        this.mMiddleColumnHeadersLink = null;
        this.mColumnHeaders.removeAllCells();
        this.mColumnHeaders = null;
        this.mCells.clear();
        this.mCells = null;
        this.mRowHeaders.removeAllCells();
        this.mRowHeaders = null;
        this.mColumnWidths = null;
        this.mFontMetrics = null;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
    }

    public void setMiddleColumnHeader(String[] colHeader) {
        this.mMiddleColumnHeaders = new CellGroup(colHeader);
        this.mMiddleColumnHeadersLink = new int[colHeader.length];
        this.mMiddleColumnHeadersLink[0] = 0;
        for (int i = 1; i < colHeader.length; ++i) {
            this.mMiddleColumnHeadersLink[i] = colHeader[i - 1] != null && colHeader[i] != null && colHeader[i - 1].equals(colHeader[i]) ? this.mMiddleColumnHeadersLink[i - 1] : i;
        }
    }

    public String getMiddleColumnHeader(int index) {
        if (this.mMiddleColumnHeaders == null) {
            return null;
        }
        return this.mMiddleColumnHeaders.getCell(index).getValue();
    }

    @Override
    public void removeColumn(int col) {
        int row = this.mSelectedRow;
        if (this.mSelectedRow >= 0) {
            this.clearSelection();
        }
        for (int i = 0; i < this.mColumnCount; ++i) {
            CellGroup group = this.getRow(i);
            group.removeCell(col);
        }
        this.mColumnHeaders.removeCell(col);
        int cnt = 0;
        for (int i = 0; i < this.mColumnCount; ++i) {
            if (this.mMiddleColumnHeadersLink[i] != col) continue;
            ++cnt;
        }
        if (cnt == 1) {
            int[] tmp = new int[this.mMiddleColumnHeadersLink.length - 1];
            int j = 0;
            for (int i = 0; i < this.mColumnCount; ++i) {
                if (this.mMiddleColumnHeadersLink[i] == col) {
                    this.mMiddleColumnHeaders.removeCell(i);
                    continue;
                }
                tmp[j++] = this.mMiddleColumnHeadersLink[i];
            }
            this.mMiddleColumnHeadersLink = tmp;
        }
        int count = this.mColumnCount - 1;
        boolean[] editable = new boolean[count];
        int[] alignments = new int[count];
        this.mColumnWidths = new int[count];
        int j = 0;
        for (int i = 0; i < this.mColumnCount; ++i) {
            if (i == col) continue;
            editable[j] = this.mIsColumnEditables[i];
            alignments[j] = this.mColumnAlignments[i];
            this.mColumnWidths[j] = 100;
            ++j;
        }
        this.mIsColumnEditables = editable;
        this.mColumnAlignments = this.mColumnWidths;
        --this.mColumnCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(row);
    }

    protected boolean drawMiddleColumnHeader(Graphics g) {
        if (this.mMiddleColumnHeadersLink == null) {
            return false;
        }
        int x = this.mRowHeaderWidth - this.mHScrollValue;
        for (int i = 0; i < this.mColumnCount; ++i) {
            int w = this.mColumnWidths[i];
            for (int j = i + 1; j < this.mColumnCount && this.mMiddleColumnHeadersLink[i] == this.mMiddleColumnHeadersLink[j]; ++j) {
                w += this.mColumnWidths[j];
                ++i;
            }
            g.setColor(COLOR_HEADER_BACKGROUND);
            g.fillRect(x + 1, 0, w - 2, this.mRowHeight);
            g.setColor(COLOR_HEADER_TEXT);
            String value = this.mMiddleColumnHeaders.getCell(i).getValue();
            int pos = x + w / 2 - this.mFontMetrics.stringWidth(value) / 2;
            if (pos < x + 3) {
                pos = x + 3;
            }
            if (value != null && !value.equals("")) {
                g.drawString(value, pos, this.mRowHeight - 4 + 1);
                g.setColor(COLOR_TABLE_BORDER);
                g.drawLine(x + w - 1, 0, x + w - 1, this.mRowHeight - 1);
                g.setColor(COLOR_HEADER_LTBACKGROUND);
                g.drawLine(x + w, 0, x + w, this.mRowHeight - 1);
                g.drawLine(x, 2, x + w - 2, 2);
            }
            x += w;
        }
        g.setColor(COLOR_HEADER_BACKGROUND);
        g.fillRect(0, 0, this.mRowHeaderWidth + 1, this.mRowHeight);
        g.fillRect(x + 1, 0, this.mTableWidth - x, this.mRowHeight);
        g.drawLine(0, 0, 0, this.mRowHeight - 1);
        return true;
    }

    @Override
    protected void calculateEditotPosition() {
        if (this.mSelectedColumn == -1) {
            return;
        }
        int x = -this.mHScrollValue;
        for (int i = 0; i < this.mSelectedColumn; ++i) {
            int w = this.mColumnWidths[i];
            x += w;
        }
        this.mEditorX = x + this.mRowHeaderWidth;
        this.mEditorY = (this.mSelectedRow - this.mFirstRow + 1 + (this.mMiddleColumnHeadersLink != null ? 1 : 0)) * this.mRowHeight;
        this.mEditorWidth = 0;
        if (this.mColumnWidths != null) {
            this.mEditorWidth = this.mColumnWidths[this.mSelectedColumn];
        }
    }

    @Override
    protected void drawColumnHeader(Graphics g) {
        int x = this.mRowHeaderWidth - this.mHScrollValue;
        int y = 0;
        if (this.drawMiddleColumnHeader(g)) {
            y = this.mRowHeight + 1;
        }
        for (int i = 0; i < this.mColumnCount; ++i) {
            int w = this.mColumnWidths[i];
            g.setColor(COLOR_HEADER_BACKGROUND);
            g.fillRect(x + 1, y, w - 2, this.mRowHeight);
            g.setColor(COLOR_HEADER_TEXT);
            String value = this.mColumnHeaders.getCell(i).getValue();
            int pos = x + w / 2 - this.mFontMetrics.stringWidth(value) / 2;
            if (pos < x + 3) {
                pos = x + 3;
            }
            g.drawString(value, pos, y + this.mRowHeight - 4 + 1);
            g.setColor(COLOR_TABLE_BORDER);
            g.drawLine(x + w - 1, y, x + w - 1, y + this.mRowHeight - 1);
            g.setColor(COLOR_HEADER_LTBACKGROUND);
            g.drawLine(x + w, y, x + w, y + this.mRowHeight - 1);
            g.drawLine(x, y + 2, x + w - 2, y + 2);
            x += w;
        }
        g.setColor(COLOR_HEADER_BACKGROUND);
        g.fillRect(0, y, this.mRowHeaderWidth + 1, this.mRowHeight);
        g.fillRect(x + 1, y, this.mTableWidth - x, this.mRowHeight);
        g.drawLine(0, y, 0, y + this.mRowHeight - 1);
    }

    @Override
    protected void drawRows(Graphics g) {
        int y;
        int j = 0;
        for (y = this.mRowHeight + 1 - this.mVScrollValue; y < this.mRowHeight + 1; y += this.mRowHeight) {
            ++j;
        }
        this.mFirstRow = j;
        if (this.mMiddleColumnHeadersLink != null) {
            y += this.mRowHeight + 1;
        }
        while (y < this.mTableHeight && j < this.mRowCount) {
            int x = this.mRowHeaderWidth - this.mHScrollValue;
            for (int i = 0; i < this.mColumnCount; ++i) {
                int strX;
                Cell cell = this.getCell(j, i);
                Color background = this.mSelectedRow == j ? COLOR_SELECTED_ROW : this.getTableBackgroundColor(cell.getType());
                g.setColor(background);
                int colWidth = this.mColumnWidths[i];
                g.fillRect(x, y, colWidth - 1, this.mRowHeight - 1);
                g.setColor(COLOR_CELL_TEXT);
                String value = this.getValueAt(j, i);
                int strWidth = this.mFontMetrics.stringWidth(value);
                if (strWidth + 6 < colWidth) {
                    switch (this.getAlignment(j, i)) {
                        case 1: {
                            strX = x + (colWidth - strWidth) / 2;
                            break;
                        }
                        case 2: {
                            strX = x + colWidth - strWidth - 3;
                            break;
                        }
                        default: {
                            strX = x + 3;
                            break;
                        }
                    }
                } else {
                    strX = x + 3;
                }
                g.drawString(value, strX, y + this.mRowHeight - 4);
                g.setColor(COLOR_CELL_BORDER);
                g.drawLine(x + colWidth - 1, y, x + colWidth - 1, y + this.mRowHeight - 1);
                g.drawLine(x, y + this.mRowHeight - 1, x + colWidth - 1, y + this.mRowHeight - 1);
                x += colWidth;
            }
            this.drawRowHeader(g, this.mRowHeaders.getCell(j).getValue(), x, y);
            ++j;
            y += this.mRowHeight;
        }
    }

    protected class MouseClickListener
    extends MouseAdapter {
        protected int clickCount = 2;

        protected MouseClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            if (MiddleColumnHeaderTable.this.mRowHeight == 0 || x > MiddleColumnHeaderTable.this.mTableWidth || y > MiddleColumnHeaderTable.this.mTableHeight) {
                MiddleColumnHeaderTable.this.mSelectedRow = -1;
                MiddleColumnHeaderTable.this.clearSelection();
                return;
            }
            x += MiddleColumnHeaderTable.this.mHScrollValue - MiddleColumnHeaderTable.this.mRowHeaderWidth;
            int col = -1;
            for (int i = 0; i < MiddleColumnHeaderTable.this.mColumnCount; ++i) {
                int w = MiddleColumnHeaderTable.this.mColumnWidths[i];
                if (x >= 0 && x <= w) {
                    col = i;
                    break;
                }
                x -= w;
            }
            if (MiddleColumnHeaderTable.this.mEditor.isEnabled()) {
                MiddleColumnHeaderTable.this.select(-1, -1);
            }
            if (y < MiddleColumnHeaderTable.this.mRowHeight) {
                return;
            }
            int row = y / MiddleColumnHeaderTable.this.mRowHeight - 1 + MiddleColumnHeaderTable.this.mFirstRow + (MiddleColumnHeaderTable.this.mMiddleColumnHeadersLink != null ? -1 : 0);
            if (event.getX() < MiddleColumnHeaderTable.this.mRowHeaderWidth && y < MiddleColumnHeaderTable.this.mRowHeight * (MiddleColumnHeaderTable.this.mRowCount + 1)) {
                MiddleColumnHeaderTable.this.selectRow(row);
            } else if (row >= 0 && row < MiddleColumnHeaderTable.this.mRowCount) {
                if (col >= 0 && col < MiddleColumnHeaderTable.this.mColumnCount) {
                    Cell cell = MiddleColumnHeaderTable.this.getCell(row, col);
                    if (cell.getType() == 1) {
                        MiddleColumnHeaderTable.this.select(row, col);
                        cell.getClickAction().doAction();
                    } else if (event.getClickCount() >= this.clickCount) {
                        MiddleColumnHeaderTable.this.select(row, col);
                    } else {
                        MiddleColumnHeaderTable.this.selectRow(row);
                    }
                } else {
                    MiddleColumnHeaderTable.this.select(row, -1);
                }
            } else {
                MiddleColumnHeaderTable.this.mSelectedRow = -1;
                MiddleColumnHeaderTable.this.clearSelection();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.getX() > MiddleColumnHeaderTable.this.mTableWidth) {
                MiddleColumnHeaderTable.this.setCursor(new Cursor(0));
            }
        }

        public void setClickCount(int count) {
            this.clickCount = count;
        }
    }
}

