/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jp.kitec.kwt.KCursor;
import jp.kitec.kwt.KCursorManager;
import jp.kitec.richui.TipsMessage;

public class GButton
extends Canvas
implements MouseListener,
FocusListener {
    private ActionListener _actionListener;
    private ActionEvent _actionEvent;
    private Image _imageDef;
    private Image _imageActive;
    private Image _imageDisable;
    private Image _imageHilight;
    private Dimension _imageSize;
    private boolean _pressFlag = false;
    private boolean _innerFlag = false;
    private String mTitle;
    private boolean mEnable;
    private boolean mActive = false;
    private boolean mDrawFrame = false;
    private Color _bacColor;
    private Color _activeBacColor;
    private TipsMessage _tipMes;
    private String _tip = null;
    private boolean mIsRadioMode = false;
    private boolean drawImage = true;
    private static Cursor _handCursor = KCursorManager.getCursor((KCursor)KCursor.CURSOR_HAND);
    private static Cursor _defCursor = KCursorManager.getCursor((KCursor)KCursor.CURSOR_DEF);
    private Image _offImage;
    private Graphics mOffGraphics;
    private boolean _handMode = false;
    private int _pushOffset = 1;
    private int mSizeOffset = 0;
    private Component mProducer;

    public GButton(String title, Image imgdef, Image imgact, Image imgdeact, Image imghilight, Color defback, Color actback, Container producer1, TipsMessage tm, int sizeofs1) {
        this._activeBacColor = actback;
        this._bacColor = defback;
        this._tipMes = tm;
        this.mSizeOffset = sizeofs1;
        this.mProducer = producer1;
        this.setBackground(this._bacColor);
        this.mTitle = title;
        this.mEnable = true;
        this.setImage(imgdef, imgact, imgdeact, imghilight);
        this.addMouseListener(this);
        this.addFocusListener(this);
    }

    public void setImage(Image imgdef, Image imgact, Image imgdeact, Image imghilight) {
        this._imageDef = imgdef;
        this._imageActive = imgact != null ? imgact : this._imageDef;
        this._imageDisable = imgdeact != null ? imgdeact : this._imageDef;
        this._imageHilight = imghilight;
        if (this._imageDef != null && this._imageActive == null) {
            this._imageActive = this._imageDef;
        } else if (this._imageDef == null && this._imageActive != null) {
            this._imageDef = this._imageActive;
        }
        if (this._imageDef == null) {
            throw new NullPointerException();
        }
        int width = this._imageDef.getWidth(null);
        int height = this._imageDef.getHeight(null);
        this._imageSize = new Dimension(width + this.mSizeOffset, height + this.mSizeOffset);
        this._offImage = this.mProducer.createImage(this._imageSize.width, this._imageSize.height);
        this.mOffGraphics = this._offImage.getGraphics();
    }

    public void setDrawImage(boolean drawImage) {
        this.drawImage = drawImage;
        this.repaint();
    }

    public void setActiveBacColor(Color c) {
        this._activeBacColor = c;
    }

    public void setRadioMode(boolean flag) {
        this.mIsRadioMode = flag;
    }

    public void setHandMode(boolean flag) {
        this._handMode = flag;
    }

    public void setDrawFrame(boolean b) {
        this.mDrawFrame = b;
        this.repaint();
    }

    public void setPushOffset(int b) {
        this._pushOffset = b;
    }

    public void setTip(String s) {
        this._tip = s;
    }

    @Override
    public Dimension getPreferredSize() {
        return this._imageSize;
    }

    @Override
    public Dimension getSize() {
        return this._imageSize;
    }

    public String getLabel() {
        return this.mTitle;
    }

    public void setActive(boolean b) {
        this.mActive = b;
        this.repaint();
    }

    public boolean isActive() {
        return this.mActive;
    }

    public void setEnabled1(boolean b) {
        this.mEnable = b;
        if (!this.mEnable) {
            if (this._handMode) {
                this.setCursor(_defCursor);
            }
            this.mActive = false;
        }
        this.repaint();
    }

    public boolean isEnabled1() {
        return this.mEnable;
    }

    public void addActionListener(ActionListener l) {
        this._actionEvent = new ActionEvent(this, 0, null);
        this._actionListener = l;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        Color c;
        boolean hekomi;
        Image img = null;
        int ofs = 0;
        boolean bl = hekomi = this.mActive || this._pressFlag;
        if (hekomi) {
            c = this._activeBacColor;
            img = this._imageActive;
            ofs = this._pushOffset;
        } else {
            c = this._bacColor;
            img = this.mEnable ? this._imageDef : this._imageDisable;
        }
        if (this._innerFlag && this._imageHilight != null && this.isEnabled1()) {
            img = this._imageHilight;
        }
        this.mOffGraphics.setColor(c);
        this.mOffGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.drawImage) {
            this.mOffGraphics.drawImage(img, ofs, ofs, this);
            if (this.mDrawFrame && this.mEnable) {
                this.mOffGraphics.setColor(c.darker().darker());
                this.mOffGraphics.drawRect(0, 0, this._imageSize.width - 1, this._imageSize.height - 1);
                this.mOffGraphics.setColor(c.brighter());
                this.mOffGraphics.draw3DRect(1, 1, this._imageSize.width - 3, this._imageSize.height - 3, !hekomi);
            }
        }
        g.drawImage(this._offImage, 0, 0, null);
    }

    private void gogo() {
        if (this.mIsRadioMode) {
            this.setActive(!this.isActive());
            this.repaint();
        }
        if (this._actionListener != null) {
            this._actionListener.actionPerformed(this._actionEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.mEnable || !this.drawImage) {
            return;
        }
        this._pressFlag = true;
        this._innerFlag = true;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.mEnable || !this.drawImage) {
            return;
        }
        if (!this.contains(e.getX(), e.getY()) && this._innerFlag) {
            this._innerFlag = false;
            this.repaint();
        } else if (this.contains(e.getX(), e.getY()) && !this._innerFlag) {
            this._innerFlag = true;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!(this.mEnable && this.drawImage || this._pressFlag)) {
            return;
        }
        if (this._innerFlag && this._pressFlag) {
            this.gogo();
        }
        this._pressFlag = false;
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this._tipMes != null && this.drawImage) {
            this._tipMes.setMessage(this._tip);
            this._tipMes.update();
        }
        if (this._handMode) {
            if (!this.mEnable || !this.drawImage) {
                this.setCursor(_defCursor);
                return;
            }
            this.setCursor(_handCursor);
        }
        this._innerFlag = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseExit();
    }

    protected void mouseExit() {
        if (this._tipMes != null && this.drawImage) {
            this._tipMes.setMessage(null);
            this._tipMes.update();
        }
        if (this._handMode) {
            this.setCursor(_defCursor);
        }
        this._innerFlag = false;
        this.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.mouseExit();
    }
}

