/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import jp.kitec.kwt.KColor;
import jp.kitec.kwt.KwtAwtConverter;
import jp.kitec.richui.AScrollBar;
import jp.kitec.richui.CaptPanel;

class AScrollPanel
extends Panel {
    private Graphics mOffg;
    private Image mOffImg;
    private final Dimension mOldD;
    private final double width = 14.0;
    private final Rectangle tipRect;
    private double cp1x;
    private double cp2x;
    private double cpy;
    private double mValueDev;
    private CaptPanel mCaptPanel;
    protected Image mTex;
    private final AScrollBar mParentBar;
    private final Color mThemeColor;

    protected AScrollPanel(AScrollBar as, Color theme) {
        this(as, theme, null, 0);
    }

    protected AScrollPanel(AScrollBar as, Color theme, Object parent, int id) {
        this.setBackground(Color.lightGray);
        this.mParentBar = as;
        this.mThemeColor = theme;
        this.tipRect = new Rectangle();
        this.mOldD = new Dimension();
    }

    public void setCaptPanel(CaptPanel captPanel) {
        this.mCaptPanel = captPanel;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        this.culcTipRect();
        if (this.mOffImg == null || this.getWidth() != this.mOldD.width || this.getHeight() != this.mOldD.height) {
            if (this.mOffg != null) {
                this.mOffg.dispose();
            }
            if (this.mOffImg != null) {
                this.mOffImg.flush();
            }
            this.mOffImg = this.createImage(this.getWidth(), this.getHeight());
            this.mOffg = this.mOffImg.getGraphics();
        }
        if (this.mTex != null) {
            for (int x = 0; x < this.getWidth(); x += AScrollBar.xw) {
                for (int y = 0; y < this.getHeight(); y += AScrollBar.yw) {
                    this.mOffg.drawImage(this.mTex, x, y, null);
                }
            }
        } else {
            this.mOffg.setColor(KwtAwtConverter.asAwtColor((KColor)KColor.MORELIGHT_GRAY));
            this.mOffg.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.mOffg.setColor(this.mThemeColor.darker());
        this.mOffg.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.mOffg.setColor(Color.gray);
        if (this.mParentBar.mCenterLine) {
            if (this.mParentBar.mMode == AScrollBar.MODE_HOR) {
                this.mOffg.fill3DRect((int)this.cp1x, (int)this.cpy - 1, (int)this.cp2x - (int)this.cp1x, 2, false);
            } else {
                this.mOffg.fill3DRect((int)this.cpy - 1, (int)this.cp1x, 2, (int)this.cp2x - (int)this.cp1x, false);
            }
        }
        if (this.mParentBar.isEnabled()) {
            this.mOffg.setColor(this.mThemeColor);
            this.mOffg.fillRect(this.tipRect.x, this.tipRect.y, this.tipRect.width, this.tipRect.height);
            this.mOffg.setColor(this.mThemeColor.darker().darker());
            this.mOffg.draw3DRect(this.tipRect.x, this.tipRect.y, this.tipRect.width, this.tipRect.height, true);
            this.mOffg.setColor(this.mThemeColor.brighter());
            this.mOffg.draw3DRect(this.tipRect.x + 1, this.tipRect.y + 1, this.tipRect.width - 2, this.tipRect.height - 2, true);
        }
        g.drawImage(this.mOffImg, 0, 0, null);
        this.mOldD.width = this.getWidth();
        this.mOldD.height = this.getHeight();
    }

    protected boolean isInController(int x, int y) {
        return this.tipRect.contains(x, y);
    }

    private void culcTipRect() {
        if (this.mParentBar.mMode == AScrollBar.MODE_HOR) {
            this.cp1x = 10.0;
            this.cp2x = (double)this.getWidth() - 10.0;
            this.cpy = (double)this.getHeight() / 2.0;
        } else {
            this.cp1x = 10.0;
            this.cp2x = (double)this.getHeight() - 10.0;
            this.cpy = (double)this.getWidth() / 2.0;
        }
        double tmpval = this.mParentBar.mValue;
        if (tmpval < this.mParentBar.mValueMin) {
            tmpval = this.mParentBar.mValue = this.mParentBar.mValueMin;
        }
        if (tmpval > this.mParentBar.mValueMax) {
            tmpval = this.mParentBar.mValue = this.mParentBar.mValueMax;
        }
        this.mValueDev = this.cp1x + (this.cp2x - this.cp1x) * (tmpval - this.mParentBar.mValueMin) / (this.mParentBar.mValueMax - this.mParentBar.mValueMin);
        if (this.mParentBar.mMode == AScrollBar.MODE_HOR) {
            this.tipRect.setBounds((int)(this.mValueDev - 7.0), 1, 14, this.getHeight() - 3);
        } else {
            int w = 7;
            this.tipRect.setBounds(1, (int)(this.mValueDev - (double)w), this.getWidth() - 3, w * 2);
        }
        if (this.mCaptPanel != null && !this.mCaptPanel.mInit) {
            this.mCaptPanel.mInit = true;
            this.mCaptPanel.repaint();
        }
    }

    protected double devToVal(int x) {
        double val = this.mParentBar.mValueMin + ((double)x - this.cp1x) / (this.cp2x - this.cp1x) * (this.mParentBar.mValueMax - this.mParentBar.mValueMin);
        if (val < this.mParentBar.mValueMin) {
            return this.mParentBar.mValueMin;
        }
        if (val > this.mParentBar.mValueMax) {
            return this.mParentBar.mValueMax;
        }
        return val;
    }

    protected int valToDev(double val) {
        int x = (int)((val - this.mParentBar.mValueMin) * (this.cp2x - this.cp1x) / (this.mParentBar.mValueMax - this.mParentBar.mValueMin) + this.cp1x);
        return x;
    }
}

