/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import jp.kitec.richui.table.Cell;
import jp.kitec.richui.table.CellClickAction;
import jp.kitec.richui.table.CellGroup;
import jp.kitec.richui.table.ITableKeyListener;

public class Table
extends JPanel {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected static final int CELL_HINSET = 3;
    protected static final int CELL_VINSET = 2;
    protected static final int SIZE_SCROLLBAR = 15;
    protected static final Color COLOR_TABLE_BORDER = new Color(99, 101, 99);
    protected static final Color COLOR_TABLE_BACKGROUND = Color.white;
    protected static final Color COLOR_BUTTON_BACKGROUND = new Color(0.8f, 1.0f, 1.0f);
    protected static final Color COLOR_HEADER_BACKGROUND = new Color(214, 211, 206);
    protected static final Color COLOR_HEADER_LTBACKGROUND = Color.white;
    protected static final Color COLOR_HEADER_TEXT = Color.black;
    protected static final Color COLOR_CELL_BORDER = new Color(156, 154, 156);
    protected static final Color COLOR_CELL_TEXT = Color.black;
    protected static final Color COLOR_SELECTED_ROW = new Color(206, 207, 255);
    protected static final Font DEF_FONT = new Font("Monospaced", 0, 14);
    protected static final Color COLOR_ENABLEDTABLE_BACKGROUND = COLOR_HEADER_BACKGROUND;
    protected int[][] unremovableCellType;
    protected AdjustmentListener mLsnScrollbar;
    protected MouseListener mLsnMouseClick;
    protected MouseMotionListener mLsnMouseDrag;
    protected MouseWheelListener mLsnMouseWheel;
    protected EditorKeyListener mLsnEditorKey;
    protected Dimension mMinimumSize;
    protected Font mFont;
    protected FontMetrics mFontMetrics;
    protected Graphics mOffGraphics;
    protected Image mOffImage;
    protected int mTableWidth;
    protected int mTableHeight;
    protected int mRowHeaderWidth;
    protected int mRowHeight;
    protected int mFirstRow;
    protected int mTotalColumnWidth;
    protected int mHScrollValue;
    protected int mVScrollValue;
    protected List<CellGroup> mCells;
    protected CellGroup mRowHeaders;
    protected CellGroup mColumnHeaders;
    protected int[] mColumnWidths;
    protected int mColumnCount;
    protected int mRowCount;
    protected JScrollBar mSrlHorizontal;
    protected JScrollBar mSrlVertical;
    protected int mHScrollbarWidth;
    protected int mVScrollbarHeight;
    protected int mDraggedX;
    protected int mDraggedColumn;
    protected TextField mEditor;
    protected int mEditorX;
    protected int mEditorY;
    protected int mEditorWidth;
    protected int mSelectedRow;
    protected int mSelectedColumn;
    protected boolean mAutoResizeColumnWidth = true;
    protected boolean mIsResized;
    protected int[] mColumnAlignments;
    protected boolean[] mIsColumnEditables;
    protected boolean mIsRowHeaderShown = true;
    protected ITableKeyListener mKeyHandler = null;
    protected int mHandleRow;
    protected int mHandleCol;
    protected int mHandleKey;

    public void addKeyHandler(int col, int row, int key, ITableKeyListener keyListener) {
        this.mHandleRow = row;
        this.mHandleCol = col;
        this.mHandleKey = key;
        this.mKeyHandler = keyListener;
    }

    public Table() {
        this(true);
    }

    public Table(int[][] iUnremovableCellType) {
        this();
        this.unremovableCellType = iUnremovableCellType;
    }

    public Table(boolean canScroll) {
        this.setLayout(null);
        this.mSelectedRow = -1;
        this.setFont(DEF_FONT);
        this.unremovableCellType = null;
        this.add(this.createEditor());
        if (canScroll) {
            this.addScrollbar();
        }
        this.addMouseEventListener();
    }

    public void init() {
        this.mColumnHeaders.removeAllCells();
        this.mCells.clear();
        this.mRowHeaders.removeAllCells();
        this.mTableWidth = 0;
        this.mTableHeight = 0;
        this.mRowHeaderWidth = 0;
        this.mRowHeight = 0;
        this.mFirstRow = 0;
        this.mTotalColumnWidth = 0;
        this.mHScrollValue = 0;
        this.mVScrollValue = 0;
        this.mColumnWidths = null;
        this.mColumnCount = 0;
        this.mRowCount = 0;
        this.mHScrollbarWidth = 0;
        this.mVScrollbarHeight = 0;
        this.mDraggedX = 0;
        this.mDraggedColumn = 0;
        this.mEditorX = 0;
        this.mEditorY = 0;
        this.mEditorWidth = 0;
        this.mSelectedRow = -1;
        this.mSelectedColumn = -1;
        this.mAutoResizeColumnWidth = true;
        this.mIsResized = true;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
        if (this.mSrlHorizontal != null) {
            this.mSrlHorizontal.setValue(0);
        }
        if (this.mSrlVertical != null) {
            this.mSrlVertical.setValue(0);
        }
    }

    protected Component createEditor() {
        this.mEditor = new TextField();
        this.mLsnEditorKey = new EditorKeyListener();
        this.mEditor.addKeyListener(this.mLsnEditorKey);
        this.mEditor.setFont(this.getFont());
        this.mEditor.addFocusListener(new EditorFocusListener());
        return this.mEditor;
    }

    protected void addScrollbar() {
        this.mSrlHorizontal = new JScrollBar(0);
        this.add(this.mSrlHorizontal);
        this.mSrlVertical = new JScrollBar(1);
        this.add(this.mSrlVertical);
        this.mLsnScrollbar = new AdjustmentListenerImpl();
        this.mSrlHorizontal.addAdjustmentListener(this.mLsnScrollbar);
        this.mSrlVertical.addAdjustmentListener(this.mLsnScrollbar);
    }

    protected void addMouseEventListener() {
        this.mLsnMouseClick = new MouseListenerImpl();
        this.addMouseListener(this.mLsnMouseClick);
        this.mLsnMouseDrag = new MouseMotionListenerImpl();
        this.addMouseMotionListener(this.mLsnMouseDrag);
        this.mLsnMouseWheel = new MouseWheelListenerImpl();
        this.addMouseWheelListener(this.mLsnMouseWheel);
    }

    public void dispose() {
        this.disposeOffImage();
        this.mColumnHeaders.removeAllCells();
        this.mColumnHeaders = null;
        this.mCells.clear();
        this.mCells = null;
        this.mRowHeaders.removeAllCells();
        this.mRowHeaders = null;
        this.mColumnWidths = null;
        this.mFontMetrics = null;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.repaint();
    }

    public Color getTableBackgroundColor() {
        return this.getTableBackgroundColor(0);
    }

    public Color getTableBackgroundColor(int type) {
        if (type == 1) {
            return this.isEnabled() ? COLOR_BUTTON_BACKGROUND : COLOR_ENABLEDTABLE_BACKGROUND;
        }
        return this.isEnabled() ? COLOR_TABLE_BACKGROUND : COLOR_ENABLEDTABLE_BACKGROUND;
    }

    protected void disposeOffImage() {
        if (this.mOffGraphics != null) {
            this.mOffGraphics.dispose();
            this.mOffGraphics = null;
        }
        if (this.mOffImage != null) {
            this.mOffImage.flush();
            this.mOffImage = null;
        }
    }

    @Override
    public void setFont(Font font) {
        this.mFont = font;
        this.mFontMetrics = null;
        this.mIsResized = true;
        this.mRowHeight = 0;
        this.repaint();
    }

    @Override
    public Font getFont() {
        if (this.mFont == null) {
            return super.getFont();
        }
        return new Font(this.mFont.getName(), this.mFont.getStyle(), this.mFont.getSize());
    }

    protected boolean isDragged() {
        return this.getCursor().getType() == 11;
    }

    protected void setDragged(boolean b) {
        if (b) {
            this.setCursor(new Cursor(11));
        } else {
            this.setCursor(new Cursor(0));
            this.mDraggedColumn = -1;
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int newWidth;
        super.setBounds(x, y, width, height);
        if (this.mSrlHorizontal != null) {
            this.mVScrollbarHeight = this.mSrlHorizontal.getPreferredSize().height;
        }
        if (this.mSrlVertical != null) {
            this.mHScrollbarWidth = this.mSrlVertical.getPreferredSize().width;
        }
        if (this.mVScrollbarHeight == 0) {
            this.mVScrollbarHeight = 15;
        }
        if (this.mHScrollbarWidth == 0) {
            this.mHScrollbarWidth = 15;
        }
        if ((newWidth = width - this.mHScrollbarWidth) != this.mTableWidth) {
            this.calculateAllColumnWidths();
            this.adjustScroll();
            this.mTableWidth = newWidth;
        }
        this.mTableHeight = height - this.mVScrollbarHeight;
        if (this.mSrlHorizontal != null) {
            this.mSrlHorizontal.setBounds(0, this.mTableHeight, this.mTableWidth, this.mVScrollbarHeight);
        }
        if (this.mSrlVertical != null) {
            this.mSrlVertical.setBounds(this.mTableWidth, 0, this.mHScrollbarWidth, this.mTableHeight);
        }
        this.adjustScroll();
        this.mIsResized = true;
        this.setEditor();
        this.repaint();
    }

    public void setColumnHeader(String[] colHeader) {
        this.mCells = new ArrayList<CellGroup>();
        this.mRowHeaders = new CellGroup();
        this.mColumnCount = colHeader.length;
        this.mColumnHeaders = new CellGroup(colHeader);
        this.mColumnWidths = new int[this.mColumnCount];
        this.mColumnAlignments = new int[this.mColumnCount];
        this.mIsColumnEditables = new boolean[this.mColumnCount];
        for (int i = 0; i < this.mColumnCount; ++i) {
            this.mColumnWidths[i] = 100;
            this.mColumnAlignments[i] = 0;
            this.mIsColumnEditables[i] = false;
        }
        this.mRowCount = 0;
    }

    public String getColumnHeader(int index) {
        return this.mColumnHeaders.getCell(index).getValue();
    }

    public int getRowCount() {
        return this.mRowCount;
    }

    public int getColumnCount() {
        return this.mColumnCount;
    }

    public void addRow(String rowHeader, String[] rowData) {
        if (rowData.length != this.mColumnCount) {
            return;
        }
        this.mRowHeaders.addCell(rowHeader);
        CellGroup group = new CellGroup();
        for (int i = 0; i < this.mColumnCount; ++i) {
            group.addCell(new Cell("" + rowData[i], this.mColumnAlignments[i], this.mIsColumnEditables[i]));
        }
        this.mCells.add(group);
        ++this.mRowCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.repaint();
    }

    public void addRow(String[] rowData) {
        this.addRow("" + (this.mRowCount + 1), rowData);
    }

    public void insertRow(String[] rowData, int index) {
        this.insertRow("" + (this.mRowCount + 1), rowData, index);
    }

    public void insertRow(String[] rowData, int[] type, CellClickAction[] action, int index) {
        this.insertRow("" + (this.mRowCount + 1), rowData, type, action, index);
    }

    public void insertRow(String[] rowData, int index, int type) {
        this.insertRow("" + (this.mRowCount + 1), rowData, index, type);
    }

    public void insertRow(String[] rowData, int index, int type, boolean[] columnEditables) {
        this.insertRow("" + (this.mRowCount + 1), rowData, index, type, columnEditables);
    }

    public void insertRow(String rowHeader, String[] rowData, int index, int type) {
        this.insertRow(rowHeader, rowData, index, type, this.mIsColumnEditables);
    }

    public void insertRow(String rowHeader, String[] rowData, int index, int type, boolean[] columnEditables) {
        if (rowData.length != this.mColumnCount) {
            return;
        }
        this.mRowHeaders.addCell(rowHeader);
        CellGroup group = new CellGroup();
        group.setType(type);
        for (int i = 0; i < this.mColumnCount; ++i) {
            group.addCell(new Cell("" + rowData[i], this.mColumnAlignments[i], columnEditables[i]));
        }
        this.mCells.add(index, group);
        ++this.mRowCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(index);
    }

    public void insertRow(String rowHeader, String[] rowData, int index) {
        if (rowData.length != this.mColumnCount) {
            return;
        }
        this.mRowHeaders.addCell(rowHeader);
        CellGroup group = new CellGroup();
        for (int i = 0; i < this.mColumnCount; ++i) {
            group.addCell(new Cell("" + rowData[i], this.mColumnAlignments[i], this.mIsColumnEditables[i]));
        }
        this.mCells.add(index, group);
        ++this.mRowCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(index);
    }

    public void insertRow(String rowHeader, String[] rowData, int[] type, CellClickAction[] action, int index) {
        if (rowData.length != this.mColumnCount) {
            return;
        }
        this.mRowHeaders.addCell(rowHeader);
        CellGroup group = new CellGroup();
        for (int i = 0; i < this.mColumnCount; ++i) {
            group.addCell(new Cell("" + rowData[i], this.mColumnAlignments[i], type[i], action[i], this.mIsColumnEditables[i]));
        }
        this.mCells.add(index, group);
        ++this.mRowCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(index);
    }

    public String getValueAt(int row, int col) {
        return this.getCell(row, col).getValue();
    }

    public int getRowTypeAt(int row) {
        return this.getRow(row).getType();
    }

    public void setRowTypeAt(int row, int type) {
        this.getRow(row).setType(type);
    }

    protected Cell getCell(int row, int col) {
        return this.getRow(row).getCell(col);
    }

    public CellGroup getRow(int row) {
        return this.mCells.get(row);
    }

    public void setValueAt(int row, int col, String value) {
        this.getCell(row, col).setValue(value);
    }

    @Override
    public void removeAll() {
        this.mRowCount = 0;
        this.mCells.clear();
        this.calculateAllColumnWidths();
        this.mRowHeaders.removeAllCells();
        this.mFirstRow = 0;
        this.mHScrollValue = 0;
        this.mVScrollValue = 0;
        this.mRowCount = 0;
        this.mDraggedX = 0;
        this.mDraggedColumn = 0;
        this.mEditorX = 0;
        this.mEditorY = 0;
        this.mEditorWidth = 0;
        this.mSelectedRow = -1;
        this.mSelectedColumn = -1;
        if (this.mSrlHorizontal != null) {
            this.mSrlHorizontal.setValue(0);
        }
        if (this.mSrlVertical != null) {
            this.mSrlVertical.setValue(0);
        }
    }

    public void removeRow(int row) {
        if (this.mSelectedRow >= 0) {
            this.clearSelection();
        }
        if (this.unremovableCellType != null) {
            CellGroup group = this.mCells.get(row);
            for (int[] element : this.unremovableCellType) {
                int[] values = element;
                if (values.length == 1 && group.getType() == values[0]) {
                    return;
                }
                if (values.length != 2 || group.getType() < values[0] || group.getType() > values[1]) continue;
                return;
            }
        }
        this.mCells.remove(row);
        --this.mRowCount;
        this.renumberRowHeaders();
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(this.mRowCount <= row ? this.mRowCount - 1 : row);
    }

    public void removeColumn(int col) {
        int row = this.mSelectedRow;
        if (this.mSelectedRow >= 0) {
            this.clearSelection();
        }
        for (int i = 0; i < this.mRowCount; ++i) {
            CellGroup group = this.getRow(i);
            group.removeCell(col);
        }
        this.mColumnHeaders.removeCell(col);
        int count = this.mColumnCount - 1;
        boolean[] editable = new boolean[count];
        int[] alignments = new int[count];
        this.mColumnWidths = new int[count];
        int j = 0;
        for (int i = 0; i < this.mColumnCount; ++i) {
            if (i == col) continue;
            editable[j] = this.mIsColumnEditables[i];
            alignments[j] = this.mColumnAlignments[i];
            this.mColumnWidths[j] = 100;
            ++j;
        }
        this.mIsColumnEditables = editable;
        this.mColumnAlignments = this.mColumnWidths;
        --this.mColumnCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(row);
    }

    protected void renumberRowHeaders() {
        this.mRowHeaders.removeAllCells();
        for (int i = 1; i <= this.mRowCount; ++i) {
            this.mRowHeaders.addCell("" + i);
        }
    }

    public void setRowIdentify(int row, int identify) {
        this.getRow(row).setIdentify(identify);
    }

    public boolean isEditable(int row, int col) {
        return this.getCell(row, col).isEditable();
    }

    public void setEditable(int row, int col, boolean b) {
        this.getCell(row, col).setEditable(b);
    }

    public void setRowEditable(int row, boolean b) {
        for (int i = 0; i < this.mColumnCount; ++i) {
            this.setEditable(row, i, b);
        }
    }

    public void setColumnEditable(int col, boolean b) {
        if (this.mRowCount <= 0) {
            this.mIsColumnEditables[col] = b;
        } else {
            for (int i = 0; i < this.mRowCount; ++i) {
                this.setEditable(i, col, b);
            }
        }
    }

    public void setTableEditable(boolean b) {
        for (int i = 0; i < this.mColumnCount; ++i) {
            this.setColumnEditable(i, b);
        }
    }

    public void setAlignment(int row, int col, int alignment) {
        this.getCell(row, col).setAlignment(alignment);
    }

    public void setRowAlignment(int row, int alignment) {
        for (int i = 0; i < this.mColumnCount; ++i) {
            this.setAlignment(row, i, alignment);
        }
    }

    public void setColumnAlignment(int col, int alignment) {
        if (this.mRowCount <= 0) {
            this.mColumnAlignments[col] = alignment;
        } else {
            for (int i = 0; i < this.mRowCount; ++i) {
                this.setAlignment(i, col, alignment);
            }
        }
    }

    public int getAlignment(int row, int col) {
        return this.getCell(row, col).getAlignment();
    }

    public void setColumnWidth(int col, int width) {
        this.mColumnWidths[col] = width;
    }

    public int getColumnWidth(int col) {
        return this.mColumnWidths[col];
    }

    public int getSelectedRow() {
        return this.mSelectedRow;
    }

    public int getSelectedColumn() {
        return this.mSelectedColumn;
    }

    public void select(int row, int col) {
        if (this.mSelectedRow >= 0 && this.mSelectedRow < this.mRowCount && this.mSelectedColumn >= 0 && this.mSelectedColumn < this.mColumnCount) {
            this.setValueAt(this.mSelectedRow, this.mSelectedColumn, this.mEditor.getText());
        }
        this.mSelectedRow = row;
        this.mSelectedColumn = col;
        if (row < 0 || row >= this.mRowCount || col < 0 || col >= this.mColumnCount) {
            this.mSelectedRow = -1;
            this.mSelectedColumn = 0;
        }
        this.mEditor.setVisible(false);
        if (this.mSelectedRow >= 0) {
            while (this.mSelectedRow < this.mFirstRow && this.mFirstRow > 0) {
                --this.mFirstRow;
                this.mVScrollValue -= this.mRowHeight;
            }
            while (this.mSelectedRow > this.mFirstRow - 2 + this.mTableHeight / this.mRowHeight && this.mFirstRow < this.mRowCount - 1) {
                ++this.mFirstRow;
                this.mVScrollValue += this.mRowHeight;
            }
            this.calculateEditotPosition();
            if (this.mEditorX > this.mTableWidth) {
                this.mHScrollValue += this.mEditorX - this.mTableWidth;
                this.calculateEditotPosition();
            }
            if (this.mEditorX + this.mEditorWidth > this.mTableWidth) {
                this.mHScrollValue += this.mEditorX + this.mEditorWidth - this.mTableWidth;
                this.calculateEditotPosition();
            }
            if (this.mEditorX < this.mRowHeaderWidth) {
                this.mHScrollValue += this.mEditorX - this.mRowHeaderWidth;
                this.calculateEditotPosition();
            }
            this.mEditor.setText(this.getValueAt(this.mSelectedRow, this.mSelectedColumn));
            this.adjustScroll();
        }
        this.repaint();
    }

    public boolean checkAfterFocusLost(int row, int col) {
        return false;
    }

    public void selectRow(int row) {
        this.mSelectedColumn = -1;
        this.mEditor.setVisible(false);
        this.mEditorWidth = 0;
        this.mSelectedRow = row;
        this.repaint();
    }

    public void selectColumn(int col) {
        this.mSelectedColumn = col;
        this.mEditor.setVisible(false);
        this.mEditorWidth = 0;
        this.repaint();
    }

    public void clearSelection() {
        this.select(-1, 0);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.mMinimumSize == null) {
            this.setMinimumSize(new Dimension(this.mTableWidth + this.mRowHeaderWidth + this.mHScrollbarWidth + 2, this.mTableHeight + this.mVScrollbarHeight));
        }
        return this.mMinimumSize;
    }

    @Override
    public void setMinimumSize(Dimension d) {
        this.mMinimumSize = d;
    }

    public void setAutoResizeColumnWidth(boolean b) {
        this.mAutoResizeColumnWidth = b;
    }

    public boolean isAutoResizeColumnWidth() {
        return this.mAutoResizeColumnWidth;
    }

    public void showRowHeader() {
        this.mIsRowHeaderShown = true;
    }

    public void hideRowHeader() {
        this.mIsRowHeaderShown = false;
        this.mRowHeaderWidth = 0;
    }

    protected void adjustScroll() {
        if (this.mRowHeight == 0) {
            return;
        }
        if (this.mSrlHorizontal != null) {
            this.adjustHorizontalScroll();
        }
        if (this.mSrlVertical != null) {
            this.adjustVerticalScroll();
        }
    }

    protected void adjustHorizontalScroll() {
        this.mTotalColumnWidth = 0;
        for (int i = 0; i < this.mColumnCount; ++i) {
            this.mTotalColumnWidth += this.mColumnWidths[i];
        }
        if (this.mTotalColumnWidth + this.mRowHeaderWidth - this.mTableWidth < 0) {
            this.mSrlHorizontal.setEnabled(false);
            this.mSrlHorizontal.setValue(0);
        } else {
            this.mSrlHorizontal.setEnabled(true);
            this.mSrlHorizontal.setValues(this.mHScrollValue, this.mTableWidth, 0, this.mTotalColumnWidth + this.mRowHeaderWidth);
        }
        this.mHScrollValue = this.mSrlHorizontal.getValue();
    }

    protected void adjustVerticalScroll() {
        int h = this.mTableHeight / this.mRowHeight;
        if (this.mRowCount - h < 0) {
            this.mSrlVertical.setEnabled(false);
            this.mSrlVertical.setValue(0);
        } else {
            this.mSrlVertical.setEnabled(true);
            this.mSrlVertical.setValues(this.mVScrollValue / this.mRowHeight, h, 0, this.mRowCount + 1);
        }
        this.mVScrollValue = this.mSrlVertical.getValue() * this.mRowHeight;
    }

    protected void calculateAllColumnWidths() {
        if (this.mAutoResizeColumnWidth) {
            for (int i = 0; i < this.mColumnCount; ++i) {
                this.calculateColumnWidth(i);
            }
        }
        if (this.mIsRowHeaderShown) {
            this.calculateRowHeaderWidth();
        }
        if (this.mAutoResizeColumnWidth || this.mIsRowHeaderShown) {
            this.adjustAllColumnWidths();
        }
    }

    protected void calculateColumnWidth(int col) {
        if (this.mFontMetrics == null) {
            return;
        }
        int w = 10;
        w = Math.max(w, this.mFontMetrics.stringWidth(this.mColumnHeaders.getCell(col).getValue()));
        for (int i = 0; i < this.mRowCount; ++i) {
            w = Math.max(w, this.mFontMetrics.stringWidth(this.getValueAt(i, col)));
        }
        this.mColumnWidths[col] = w + 6;
    }

    protected void calculateRowHeaderWidth() {
        if (this.mFontMetrics == null) {
            return;
        }
        this.mRowHeaderWidth = 0;
        for (int i = 0; i < this.mRowCount; ++i) {
            this.mRowHeaderWidth = Math.max(this.mRowHeaderWidth, this.mFontMetrics.stringWidth(this.mRowHeaders.getCell(i).getValue()) + 6);
        }
    }

    protected void adjustAllColumnWidths() {
        int i;
        if (this.mColumnCount <= 0) {
            return;
        }
        Dimension d = this.getSize();
        int totalWidth = this.mRowHeaderWidth - this.mHScrollValue + this.mHScrollbarWidth;
        for (int i2 = 0; i2 < this.mColumnCount; ++i2) {
            totalWidth += this.mColumnWidths[i2];
        }
        int w = (int)Math.floor((double)(d.width - totalWidth) / (double)this.mColumnCount);
        for (i = 0; i < this.mColumnCount; ++i) {
            if (this.mColumnWidths[i] + w > 0) continue;
            return;
        }
        i = 0;
        while (i < this.mColumnCount) {
            int n = i++;
            this.mColumnWidths[n] = this.mColumnWidths[n] + w;
        }
    }

    protected void calculateEditotPosition() {
        if (this.mSelectedColumn == -1) {
            return;
        }
        int x = -this.mHScrollValue;
        for (int i = 0; i < this.mSelectedColumn; ++i) {
            int w = this.mColumnWidths[i];
            x += w;
        }
        this.mEditorX = x + this.mRowHeaderWidth;
        this.mEditorY = (this.mSelectedRow - this.mFirstRow + 1) * this.mRowHeight;
        this.mEditorWidth = 0;
        if (this.mColumnWidths != null) {
            this.mEditorWidth = this.mColumnWidths[this.mSelectedColumn];
        }
    }

    protected void setEditor() {
        this.calculateEditotPosition();
        int x = this.mEditorX;
        int y = this.mEditorY;
        int w = this.mEditorWidth;
        w = Math.min(w, this.mTableWidth - x);
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (this.mSelectedRow >= 0 && w > 0 && y >= this.mRowHeight && y < this.mTableHeight - this.mRowHeight) {
            if (this.isEditable(this.mSelectedRow, this.mSelectedColumn)) {
                this.mEditor.setBounds(x, y, w, this.mRowHeight);
                if (!this.mEditor.isVisible()) {
                    this.mEditor.setVisible(true);
                    this.mEditor.requestFocus();
                    this.mEditor.selectAll();
                }
            } else {
                this.mEditor.setVisible(false);
            }
        } else if (this.mEditor.isVisible()) {
            this.mEditor.setVisible(false);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g == null) {
            return;
        }
        if (this.mTableWidth <= 0 || this.mTableHeight <= 0) {
            return;
        }
        this.createOffImage();
        if (this.mRowHeight == 0) {
            this.mRowHeight = (int)((double)this.mFont.getSize() * 1.25) + 2;
            this.calculateAllColumnWidths();
            this.adjustScroll();
        }
        this.drawTableBackground(this.mOffGraphics);
        this.drawColumnHeader(this.mOffGraphics);
        this.drawRows(this.mOffGraphics);
        this.drawTableAround(this.mOffGraphics);
        if (this.mSrlHorizontal != null && this.mSrlVertical != null) {
            this.drawScrollbarIntersection(g);
        }
        g.drawImage(this.mOffImage, 0, 0, this);
        this.setEditor();
        this.disposeOffImage();
    }

    protected void createOffImage() {
        if (this.mOffImage == null || this.mIsResized) {
            this.disposeOffImage();
            this.mOffImage = this.createImage(this.mTableWidth, this.mTableHeight);
            this.mOffGraphics = this.mOffImage.getGraphics();
            this.mOffGraphics.setFont(this.mFont);
            if (this.mFontMetrics == null) {
                this.mFontMetrics = this.mOffGraphics.getFontMetrics(this.mFont);
            }
            this.mIsResized = false;
        }
    }

    protected void drawTableBackground(Graphics g) {
        g.setColor(this.getTableBackgroundColor(0));
        g.fillRect(0, 0, this.mTableWidth, this.mTableHeight);
        g.setColor(COLOR_TABLE_BORDER);
        g.drawLine(0, this.mRowHeight, this.mTableWidth, this.mRowHeight);
    }

    protected void drawColumnHeader(Graphics g) {
        this.drawColumnHeader(g, 0);
    }

    protected void drawColumnHeader(Graphics g, int y) {
        int x = this.mRowHeaderWidth - this.mHScrollValue;
        for (int i = 0; i < this.mColumnCount; ++i) {
            int w = this.mColumnWidths[i];
            g.setColor(COLOR_HEADER_BACKGROUND);
            g.fillRect(x + 1, y, w - 2, this.mRowHeight);
            g.setColor(COLOR_HEADER_TEXT);
            String value = this.mColumnHeaders.getCell(i).getValue();
            int pos = x + w / 2 - this.mFontMetrics.stringWidth(value) / 2;
            if (pos < x + 3) {
                pos = x + 3;
            }
            g.drawString(value, pos, y + this.mRowHeight - 4 + 1);
            g.setColor(COLOR_TABLE_BORDER);
            g.drawLine(x + w - 1, y, x + w - 1, y + this.mRowHeight - 1);
            g.setColor(COLOR_HEADER_LTBACKGROUND);
            g.drawLine(x + w, y, x + w, y + this.mRowHeight - 1);
            g.drawLine(x, y + 2, x + w - 2, y + 2);
            x += w;
        }
        g.setColor(COLOR_HEADER_BACKGROUND);
        g.fillRect(0, y, this.mRowHeaderWidth + 1, this.mRowHeight);
        g.fillRect(x + 1, y, this.mTableWidth - x, this.mRowHeight);
        g.drawLine(0, y, 0, y + this.mRowHeight - 1);
    }

    protected void drawRows(Graphics g) {
        int y;
        int j = 0;
        for (y = this.mRowHeight + 1 - this.mVScrollValue; y < this.mRowHeight + 1; y += this.mRowHeight) {
            ++j;
        }
        this.mFirstRow = j;
        while (y < this.mTableHeight && j < this.mRowCount) {
            int x = this.mRowHeaderWidth - this.mHScrollValue;
            for (int i = 0; i < this.mColumnCount; ++i) {
                int strX;
                Cell cell = this.getCell(j, i);
                Color background = this.mSelectedRow == j ? COLOR_SELECTED_ROW : this.getTableBackgroundColor(cell.getType());
                g.setColor(background);
                int colWidth = this.mColumnWidths[i];
                g.fillRect(x, y, colWidth - 1, this.mRowHeight - 1);
                g.setColor(COLOR_CELL_TEXT);
                String value = this.getValueAt(j, i);
                int strWidth = this.mFontMetrics.stringWidth(value);
                if (strWidth + 6 < colWidth) {
                    switch (this.getAlignment(j, i)) {
                        case 1: {
                            strX = x + (colWidth - strWidth) / 2;
                            break;
                        }
                        case 2: {
                            strX = x + colWidth - strWidth - 3;
                            break;
                        }
                        default: {
                            strX = x + 3;
                            break;
                        }
                    }
                } else {
                    strX = x + 3;
                }
                g.drawString(value, strX, y + this.mRowHeight - 4);
                g.setColor(COLOR_CELL_BORDER);
                g.drawLine(x + colWidth - 1, y, x + colWidth - 1, y + this.mRowHeight - 1);
                g.drawLine(x, y + this.mRowHeight - 1, x + colWidth - 1, y + this.mRowHeight - 1);
                x += colWidth;
            }
            this.drawRowHeader(g, this.mRowHeaders.getCell(j).getValue(), x, y);
            ++j;
            y += this.mRowHeight;
        }
    }

    protected void drawRowHeader(Graphics g, String str, int x, int y) {
        g.setColor(COLOR_HEADER_BACKGROUND);
        g.fillRect(x, y, this.mTableWidth - x, this.mRowHeight - 1);
        if (this.mRowHeaderWidth != 0) {
            g.setColor(COLOR_HEADER_BACKGROUND);
            g.fillRect(0, y, this.mRowHeaderWidth, this.mRowHeight - 1);
            g.setColor(COLOR_HEADER_TEXT);
            int sw = this.mFontMetrics.stringWidth(str);
            int sx = (this.mRowHeaderWidth - sw) / 2;
            g.drawString(str, sx, y + this.mRowHeight - 4);
            g.setColor(COLOR_TABLE_BORDER);
            g.drawLine(0, y + this.mRowHeight - 1, this.mRowHeaderWidth - 1, y + this.mRowHeight - 1);
            g.drawLine(this.mRowHeaderWidth - 1, y, this.mRowHeaderWidth - 1, y + this.mRowHeight - 1);
            g.setColor(COLOR_HEADER_LTBACKGROUND);
            g.drawLine(0, y, this.mRowHeaderWidth - 2, y);
            g.drawLine(2, y, 2, y + this.mRowHeight - 2);
            g.setColor(COLOR_TABLE_BORDER);
            g.drawLine(this.mRowHeaderWidth - 1, 0, this.mRowHeaderWidth - 1, this.mRowHeight);
            g.setColor(COLOR_HEADER_LTBACKGROUND);
            g.drawLine(this.mRowHeaderWidth, 0, this.mRowHeaderWidth, this.mRowHeight - 1);
            g.drawLine(2, 2, this.mRowHeaderWidth - 2, 2);
            g.drawLine(2, 2, 2, this.mRowHeight - 1);
        }
    }

    protected void drawTableAround(Graphics g) {
        int w = this.mRowHeaderWidth;
        for (int i = 0; i < this.mColumnCount; ++i) {
            w += this.mColumnWidths[i];
        }
        g.setColor(this.getTableBackgroundColor(0));
        g.fillRect(--w + 1, 0, this.mTableWidth, this.mTableHeight);
        g.setColor(COLOR_HEADER_BACKGROUND);
        g.drawLine(0, 0, this.mTableWidth, 0);
        g.drawLine(0, 0, 0, this.mTableHeight);
        g.setColor(COLOR_TABLE_BORDER);
        g.drawLine(1, 1, this.mTableWidth, 1);
        g.drawLine(1, 1, 1, this.mTableHeight);
    }

    protected void drawScrollbarIntersection(Graphics g) {
        g.setColor(COLOR_HEADER_BACKGROUND);
        g.fillRect(this.mTableWidth, this.mTableHeight, this.mHScrollbarWidth, this.mVScrollbarHeight);
        g.setColor(COLOR_TABLE_BORDER);
        g.drawLine(this.mTableWidth, this.mTableHeight + this.mVScrollbarHeight - 1, this.mTableWidth + this.mHScrollbarWidth - 1, this.mTableHeight + this.mVScrollbarHeight - 1);
        g.drawLine(this.mTableWidth + this.mHScrollbarWidth - 1, this.mTableHeight, this.mTableWidth + this.mHScrollbarWidth - 1, this.mTableHeight + this.mVScrollbarHeight - 1);
    }

    protected class MouseWheelListenerImpl
    implements MouseWheelListener {
        protected MouseWheelListenerImpl() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            switch (e.getScrollType()) {
                case 0: 
                case 1: {
                    int n = e.getWheelRotation() * 2;
                    Table.this.mSrlVertical.setValue(Table.this.mSrlVertical.getValue() + n);
                    Table.this.mVScrollValue = Table.this.mSrlVertical.getValue() * Table.this.mRowHeight;
                    Table.this.adjustScroll();
                    Table.this.repaint();
                }
            }
        }
    }

    protected class MouseMotionListenerImpl
    extends MouseMotionAdapter {
        protected MouseMotionListenerImpl() {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (Table.this.mDraggedColumn == -1) {
                return;
            }
            int x = event.getX();
            int w = x - Table.this.mDraggedX;
            if (w < 0) {
                w = 0;
            }
            Table.this.mColumnWidths[Table.this.mDraggedColumn] = w;
            Table.this.adjustScroll();
            Table.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            int x = event.getX();
            if (!Table.this.isFocusable()) {
                Table.this.setFocusable(true);
            }
            if (event.getY() <= Table.this.mRowHeight) {
                int i;
                int xb = x;
                x = x + Table.this.mHScrollValue - Table.this.mTotalColumnWidth - Table.this.mRowHeaderWidth;
                for (i = Table.this.mColumnCount - 1; i >= 0 && (x <= -7 || x >= 7); x += Table.this.mColumnWidths[i], --i) {
                }
                if (i >= 0) {
                    if (!Table.this.isDragged()) {
                        Table.this.setDragged(true);
                        Table.this.mDraggedX = xb - Table.this.mColumnWidths[i];
                        Table.this.mDraggedColumn = i;
                    }
                    return;
                }
            }
            Table.this.setDragged(false);
        }
    }

    protected class MouseListenerImpl
    extends MouseAdapter {
        protected int clickCount = 2;

        protected MouseListenerImpl() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            if (Table.this.mRowHeight == 0 || x > Table.this.mTableWidth || y > Table.this.mTableHeight) {
                Table.this.mSelectedRow = -1;
                Table.this.clearSelection();
                return;
            }
            x += Table.this.mHScrollValue - Table.this.mRowHeaderWidth;
            int col = -1;
            for (int i = 0; i < Table.this.mColumnCount; ++i) {
                int w = Table.this.mColumnWidths[i];
                if (x >= 0 && x <= w) {
                    col = i;
                    break;
                }
                x -= w;
            }
            if (Table.this.mEditor.isEnabled()) {
                Table.this.select(-1, -1);
            }
            if (y < Table.this.mRowHeight) {
                return;
            }
            int row = y / Table.this.mRowHeight - 1 + Table.this.mFirstRow;
            if (event.getX() < Table.this.mRowHeaderWidth && y < Table.this.mRowHeight * (Table.this.mRowCount + 1)) {
                Table.this.selectRow(row);
            } else if (row >= 0 && row < Table.this.mRowCount) {
                if (col >= 0 && col < Table.this.mColumnCount) {
                    Cell cell = Table.this.getCell(row, col);
                    if (cell.getType() == 1) {
                        Table.this.select(row, col);
                        cell.getClickAction().doAction();
                    } else if (event.getClickCount() >= this.clickCount) {
                        Table.this.select(row, col);
                    } else {
                        Table.this.selectRow(row);
                    }
                } else {
                    Table.this.select(row, -1);
                }
            } else {
                Table.this.mSelectedRow = -1;
                Table.this.clearSelection();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.getX() > Table.this.mTableWidth) {
                Table.this.setCursor(new Cursor(0));
            }
        }

        public void setClickCount(int count) {
            this.clickCount = count;
        }
    }

    protected class AdjustmentListenerImpl
    implements AdjustmentListener {
        protected AdjustmentListenerImpl() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            Table.this.mHScrollValue = Table.this.mSrlHorizontal.getValue();
            Table.this.mVScrollValue = Table.this.mSrlVertical.getValue() * Table.this.mRowHeight;
            Table.this.repaint();
        }
    }

    protected class EditorFocusListener
    extends FocusAdapter {
        protected EditorFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            int r = Table.this.mSelectedRow;
            int c = Table.this.mSelectedColumn;
            Table.this.select(-1, -1);
            if (Table.this.checkAfterFocusLost(r, c)) {
                Table.this.repaint();
            }
        }
    }

    protected class EditorKeyListener
    extends KeyAdapter {
        protected EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            int row = Table.this.mSelectedRow;
            int col = Table.this.mSelectedColumn;
            if (row < 0 || row >= Table.this.mRowCount) {
                return;
            }
            switch (event.getKeyCode()) {
                case 9: {
                    col = (event.getModifiers() & 1) != 0 ? --col : ++col;
                    if (col < 0) {
                        col = Table.this.mColumnCount - 1;
                        if (--row < 0) {
                            row = Table.this.mRowCount - 1;
                        }
                    }
                    if (col >= Table.this.mColumnCount) {
                        col = 0;
                        if (++row >= Table.this.mRowCount) {
                            row = 0;
                        }
                    }
                    Table.this.select(row, col);
                    break;
                }
                case 10: {
                    int r = Table.this.mSelectedRow;
                    int c = Table.this.mSelectedColumn;
                    Table.this.select(-1, -1);
                    if (Table.this.checkAfterFocusLost(r, c)) {
                        Table.this.repaint();
                    }
                    Table.this.selectRow(row);
                    break;
                }
                case 27: {
                    if (Table.this.mEditor.isVisible()) {
                        Table.this.selectRow(Table.this.getSelectedRow());
                        break;
                    }
                    Table.this.clearSelection();
                }
            }
            if (!(Table.this.mKeyHandler == null || Table.this.mHandleKey != -1 && Table.this.mHandleKey != event.getKeyCode() || Table.this.mHandleRow != -1 && Table.this.mHandleRow != row || Table.this.mHandleCol != -1 && Table.this.mHandleCol != col)) {
                Table.this.mKeyHandler.keyPressedAt(event, row, col);
            }
        }
    }
}

