/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui.table;

import java.util.ArrayList;
import java.util.List;
import jp.kitec.richui.table.Cell;

public class CellGroup {
    protected List<Cell> mCells = new ArrayList<Cell>();
    protected int mIdentify;
    protected int mType;

    public CellGroup() {
    }

    public CellGroup(Cell[] cells) {
        this();
        this.addCells(cells);
    }

    public CellGroup(String[] values) {
        this();
        this.addCells(values);
    }

    public void addCell(Cell cell) {
        this.mCells.add(cell);
    }

    public void addCell(String value) {
        this.addCell(new Cell(value));
    }

    public void addCells(Cell[] cells) {
        for (Cell cell : cells) {
            this.addCell(cell);
        }
    }

    public void addCells(String[] values) {
        for (String value : values) {
            this.addCell(value);
        }
    }

    public void insertCell(Cell cell, int index) {
        this.mCells.add(index, cell);
    }

    public void insertCell(String value, int index) {
        this.mCells.add(index, new Cell(value));
    }

    public int getCellCount() {
        return this.mCells.size();
    }

    public Cell getCell(int index) {
        return this.mCells.get(index);
    }

    public void removeCell(int index) {
        this.mCells.remove(index);
    }

    public void removeAllCells() {
        this.mCells.clear();
    }

    public void setIdentify(int identify) {
        this.mIdentify = identify;
    }

    public int getIdentify() {
        return this.mIdentify;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public int getType() {
        return this.mType;
    }
}

