/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.im.InputSubset;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KFontUtil;
import jp.kitec.lib.gui.event.CallBackListener;

public class LimitedTextField
extends TextField
implements KeyListener,
FocusListener {
    private int hanNum = -1;
    private int w = 0;
    private String mStopChars = null;
    private boolean mKanjiLimit = false;
    private CallBackListener mCallBackListener;
    private static boolean mJava2 = false;

    public LimitedTextField(String s, int num, KFont f) {
        super(s);
        this.addKeyListener(this);
        this.hanNum = num;
        if (f != null) {
            this.setFont(KFontUtil.getFontObject((KFont)f));
            Graphics g = this.getGraphics();
            this.w = (int)(f.getFontMetrics((Object)g).stringWidth("\u3000") * (double)(this.hanNum / 2 + 1));
            g.dispose();
        }
    }

    public void addCallbackListener(CallBackListener l) {
        this.mCallBackListener = l;
    }

    public void setStopWords(String w) {
        this.mStopChars = w;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = this.w;
        return d;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.mCallBackListener != null) {
            this.mCallBackListener.actionCallBack((Object)this);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char cur = e.getKeyChar();
        if (this.mStopChars != null) {
            for (int i = 0; i < this.mStopChars.length(); ++i) {
                char c = this.mStopChars.charAt(i);
                if (cur != c) continue;
                e.consume();
                break;
            }
        }
        if (this.hanNum > 0) {
            int c = 0;
            int cofs = cur < '\u007f' ? 1 : 2;
            String s = this.getText();
            for (int i = 0; i < s.length(); ++i) {
                char cc = s.charAt(i);
                c = cc < '\u007f' ? ++c : (c += 2);
                if (c + cofs <= this.hanNum) continue;
                if (cur == '\b' || cur == '\u007f') break;
                e.consume();
                break;
            }
        }
    }

    public boolean isBlank() {
        String s = this.getText();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ' || s.charAt(i) == '\u3000') continue;
            return false;
        }
        return true;
    }

    public void addKanjiIMELimit() {
        if (!mJava2) {
            return;
        }
        this.mKanjiLimit = true;
        this.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!this.mKanjiLimit) {
            return;
        }
        this.getInputContext().setCharacterSubsets(new Character.Subset[]{InputSubset.KANJI});
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!this.mKanjiLimit) {
            return;
        }
        this.getInputContext().setCharacterSubsets(null);
    }

    static {
        try {
            Class<?> c = Class.forName("java.awt.im.InputContext");
            mJava2 = c != null;
        }
        catch (Exception e) {
            mJava2 = false;
        }
    }
}

