/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KFontUtil;
import jp.kitec.richui.AScrollBar;
import jp.kitec.richui.AScrollPanel;

class CaptPanel
extends Panel {
    private final KFont mFont;
    AScrollBar mAScrollBar;
    AScrollPanel mAScrollPanel;
    private double mInterval = 0.0;
    private double mIntervalBase = 0.0;
    private String mAddStr = "";
    protected boolean mInit = false;
    private Graphics mOffg;
    private Image mOffImg;
    private final Dimension mOldD;

    public CaptPanel(AScrollBar sb, AScrollPanel sp, KFont f) {
        this(sb, sp, f, null, 0);
    }

    public CaptPanel(AScrollBar sb, AScrollPanel sp, KFont f, Object parent, int id) {
        this.mAScrollBar = sb;
        this.mAScrollPanel = sp;
        this.mFont = f;
        this.mOldD = new Dimension();
    }

    public void setInterval(double val, double val2, String str) {
        this.mInterval = val;
        this.mIntervalBase = val2;
        if (str != null) {
            this.mAddStr = str;
        }
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        if (this.mInterval == 0.0 || !this.mInit) {
            return;
        }
        if (this.mOffImg == null || this.getWidth() != this.mOldD.width || this.getHeight() != this.mOldD.height) {
            if (this.mOffg != null) {
                this.mOffg.dispose();
            }
            if (this.mOffImg != null) {
                this.mOffImg.flush();
            }
            this.mOffImg = this.createImage(this.getWidth(), this.getHeight());
            this.mOffg = this.mOffImg.getGraphics();
        }
        this.mOffg.setFont(KFontUtil.getFontObject((KFont)this.mFont));
        this.mOffg.clearRect(0, 0, this.getWidth(), this.getHeight());
        double s = this.mAScrollBar.mValueMin;
        double e = this.mAScrollBar.mValueMax;
        Dimension d = new Dimension(this.getWidth(), this.getHeight());
        this.mOffg.setColor(this.getForeground());
        if (s != this.mIntervalBase) {
            this.drawText(this.mOffg, s, d);
        }
        this.drawText(this.mOffg, e, d);
        double ss = this.mIntervalBase;
        while (ss < e) {
            this.drawText(this.mOffg, ss, d);
            ss += this.mInterval;
        }
        g.drawImage(this.mOffImg, 0, 0, null);
    }

    private void drawText(Graphics g, double val, Dimension d) {
        int x = this.mAScrollPanel.valToDev(val);
        String str = String.valueOf(Integer.toString((int)val)) + this.mAddStr;
        int width = (int)this.mFont.getFontMetrics((Object)g).stringWidth(str);
        int xx = x - width / 2;
        if (xx < 0) {
            xx = 0;
        } else if (xx + width > d.width) {
            xx = d.width - width;
        }
        g.setColor(Color.black);
        g.drawString(str, xx, d.height - 1);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = 12;
        return d;
    }
}

