/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.gui.tree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KFontUtil;
import jp.kitec.lib.gui.event.ActionContainer;
import jp.kitec.lib.gui.event.ActionItem;
import jp.kitec.lib.gui.tree.FolderItem;
import jp.kitec.lib.gui.tree.NodeItem;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;

public class TreeView
extends Panel
implements MouseListener,
AdjustmentListener,
FocusListener {
    private static final int BOXWIDTH = 8;
    protected ActionContainer mActionContainer = null;
    protected Vector mItem;
    private Rectangle mVirtualArea;
    private static int mIndent = 5;
    protected static int mSpace = 2;
    protected static int mTab = 20;
    protected KFont mFont;
    protected Scrollbar mHbar;
    protected Scrollbar mVbar;
    protected Point mScroll;
    private Image mOffImage = null;
    private Graphics mOffg = null;
    private int mWidth = -1;
    private int mHeight = -1;
    private int mPrefWidth = -1;
    private int mPrefHeight = -1;
    protected NodeItem mActiveItem = null;
    protected PopupMenu mPopup;
    protected boolean mDispPop = false;
    protected int mMaxIndex = 0;
    protected boolean mPanintLock = false;
    private Object mFocusItem;
    protected Object mPresTmp = null;

    public TreeView(KFont f, ActionContainer ac) {
        this.setLayout(new BorderLayout());
        this.setActionContainer(ac);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.mVbar = new Scrollbar(1);
        this.mHbar = new Scrollbar(0);
        this.add((Component)this.mVbar, "East");
        this.add((Component)this.mHbar, "South");
        this.mFont = f;
        this.mItem = new Vector();
        this.mVirtualArea = new Rectangle(0, 0, 0, 0);
        this.setFont(KFontUtil.getFontObject((KFont)f));
        this.mScroll = new Point(0, 0);
        this.addMouseListener(this);
        this.mVbar.addAdjustmentListener(this);
        this.mHbar.addAdjustmentListener(this);
        this.updatePos();
        this.addFocusListener(this);
        this.mPopup = new PopupMenu();
        this.add(this.mPopup);
    }

    public void setActionContainer(ActionContainer ac) {
        this.mActionContainer = ac;
    }

    public void openFolder(FolderItem f) {
        if (f == null) {
            for (int i = 0; i < this.mItem.size(); ++i) {
                Object o = this.mItem.elementAt(i);
                if (!(o instanceof FolderItem) || ((FolderItem)o).isOpen()) continue;
                ((FolderItem)o).flipOpen();
            }
        } else if (!f.isOpen()) {
            f.flipOpen();
        }
        this.updatePos();
    }

    public void closeAll() {
        this.close(null);
        this.updatePos();
        this.repaint();
    }

    public void close(FolderItem of) {
        Vector children = of == null ? this.mItem : of.getItems();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                NodeItem ni = (NodeItem)children.elementAt(i);
                if (!(ni instanceof FolderItem)) continue;
                FolderItem fi = (FolderItem)ni;
                if (fi.isOpen()) {
                    fi.flipOpen();
                }
                this.close(fi);
            }
        }
    }

    public void pickup(String word) {
        for (int i = 0; i < this.mItem.size(); ++i) {
            NodeItem on = (NodeItem)this.mItem.elementAt(i);
            this.pickup(on, word);
        }
        this.mScroll.x = 0;
        this.mScroll.y = 0;
        this.mVbar.setValue(0);
        this.mHbar.setValue(0);
        this.updatePos();
        this.repaint();
    }

    private boolean pickup(NodeItem on, String word) {
        boolean result = false;
        if (word == null) {
            result = true;
        }
        if (on instanceof FolderItem) {
            FolderItem fi = (FolderItem)on;
            if (word == null) {
                fi.setVisible(true);
            }
            for (int i = 0; i < fi.getItems().size(); ++i) {
                boolean res = this.pickup((NodeItem)fi.getItems().elementAt(i), word);
                result |= res;
            }
            fi.setVisible(result);
        } else if (word == null) {
            on.setVisible(true);
            result = true;
        } else if (on.getTitle().indexOf(word) >= 0) {
            on.setVisible(true);
            result = true;
        } else {
            on.setVisible(false);
        }
        return result;
    }

    public void deleteAll() {
        this.mItem.removeAllElements();
        this.mActiveItem = null;
    }

    public void updatePos() {
        this.mVirtualArea.width = mIndent;
        this.mVirtualArea.height = mIndent;
        this.mMaxIndex = 0;
        for (int i = 0; i < this.mItem.size(); ++i) {
            this.setItemPosition(this.mItem.elementAt(i), this.mVirtualArea.x, this.mVirtualArea.y + this.mVirtualArea.height);
        }
        this.checkTreeSize();
        this.checkScroll();
        if (this.mVbar.isVisible() || this.mHbar.isVisible()) {
            int ofsx = this.mHbar.isVisible() ? -this.mScroll.x : 0;
            int ofsy = this.mVbar.isVisible() ? -this.mScroll.y : 0;
            for (int i = 0; i < this.mItem.size(); ++i) {
                this.setOffset(this.mItem.elementAt(i), ofsx, ofsy);
            }
        }
        this.mVbar.setBlockIncrement(this.mVbar.getVisibleAmount());
        this.mHbar.setBlockIncrement(this.mHbar.getVisibleAmount());
    }

    public void folderOpenClose() {
    }

    @Override
    public void paint(Graphics g) {
        Dimension viewsize = this.getSize();
        if (this.mOffImage == null || viewsize.width != this.mWidth || viewsize.height != this.mHeight) {
            this.mOffImage = this.createImage(viewsize.width, viewsize.height);
            this.mOffg = this.mOffImage.getGraphics();
            this.mWidth = viewsize.width;
            this.mHeight = viewsize.height;
            this.updatePos();
        }
        this.mOffg.setColor(this.getBackground());
        this.mOffg.fillRect(0, 0, viewsize.width - 1, viewsize.height);
        for (int i = 0; i < this.mItem.size(); ++i) {
            NodeItem ni;
            if (this.mItem.elementAt(i) == null || !(ni = (NodeItem)this.mItem.elementAt(i)).isVisible()) continue;
            this.draw(this.mOffg, this.mItem.elementAt(i));
        }
        this.mOffg.setColor(Color.lightGray);
        this.mOffg.drawRect(0, 0, viewsize.width - 1, viewsize.height - 1);
        g.drawImage(this.mOffImage, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private void checkTreeSize() {
        if (this.mVbar.isVisible()) {
            this.mVirtualArea.width += this.mVbar.getSize().width;
        }
        if (this.mHbar.isVisible()) {
            this.mVirtualArea.height += this.mHbar.getSize().height;
        }
    }

    private void checkScroll() {
        int visible;
        Dimension d = this.getSize();
        if (this.mWidth > 0 && d.width < this.mVirtualArea.width) {
            visible = (int)((float)d.width / (float)this.mVirtualArea.width * (float)(this.mVirtualArea.width - d.width));
            this.mHbar.setValues(this.mScroll.x, visible, 0, this.mVirtualArea.width - d.width + visible);
            this.mHbar.setUnitIncrement((this.mVirtualArea.width - d.width) / 5);
            this.mHbar.setVisible(true);
        } else {
            this.mHbar.setVisible(false);
            this.mScroll.x = 0;
        }
        if (this.mHeight > 0 && d.height < this.mVirtualArea.height) {
            visible = (int)((float)d.height / (float)this.mVirtualArea.height * (float)(this.mVirtualArea.height - d.height));
            this.mVbar.setValues(this.mScroll.y, visible, 0, this.mVirtualArea.height - d.height + visible);
            this.mVbar.setUnitIncrement((int)this.mFont.getSize());
            this.mVbar.setUnitIncrement(5);
            this.mVbar.setVisible(true);
        } else {
            this.mVbar.setVisible(false);
            this.mScroll.y = 0;
        }
        this.doLayout();
    }

    private void setItemPosition(Object o, int x, int y) {
        FolderItem fi;
        if (o instanceof NodeItem && !((NodeItem)o).isVisible()) {
            ((NodeItem)o).mIndex = -1;
            return;
        }
        NodeItem ni = (NodeItem)o;
        ni.mIndex = this.mMaxIndex++;
        Rectangle rect = ((NodeItem)o).setPosition(x, y);
        if (this.mVirtualArea.width < rect.x + rect.width) {
            this.mVirtualArea.width = rect.x + rect.width;
        }
        if (this.mVirtualArea.height < rect.y + rect.height) {
            this.mVirtualArea.height = rect.y + rect.height;
        }
        if (this.isFolder(o) && (fi = (FolderItem)o).isOpen()) {
            x += mTab;
            for (int i = 0; i < fi.getItems().size(); ++i) {
                this.setItemPosition(fi.getItems().elementAt(i), x, this.mVirtualArea.height);
            }
        }
    }

    protected void setOffset(Object o, int x, int y) {
        FolderItem fi;
        NodeItem ni = (NodeItem)o;
        Rectangle rect = ni.getPosition();
        rect.x += x;
        rect.y += y;
        if (this.isFolder(ni) && (fi = (FolderItem)ni).isOpen()) {
            for (int i = 0; i < fi.getItems().size(); ++i) {
                this.setOffset(fi.getItems().elementAt(i), x, y);
            }
        }
    }

    private void draw(Graphics g, Object o) {
        if (o == null) {
            return;
        }
        g.setColor(this.getForeground());
        if (this.isFolder(o)) {
            FolderItem fi = (FolderItem)o;
            this.drawNode(g, (NodeItem)fi);
            if (fi.isOpen() && fi.isVisible()) {
                int ystart = fi.getPosition().y + fi.getPosition().height;
                int yend = 0;
                for (int i = 0; i < fi.getItems().size(); ++i) {
                    NodeItem ni = (NodeItem)fi.getItems().elementAt(i);
                    if (!ni.isVisible()) continue;
                    this.draw(g, ni);
                    yend = ni.getPosition().y + ni.getPosition().height / 2;
                    if (this.isFolder(ni)) {
                        TreeView.drawLineX(g, fi.getPosition().x + mTab / 2 + mSpace + 1 + 4, yend, ni.getPosition().x, Color.black);
                        TreeView.drawLineY(g, fi.getPosition().x + mTab / 2 + mSpace, ystart + 4, yend - 4, Color.black);
                        ystart = yend;
                        this.drawBox(g, ((FolderItem)ni).isOpen(), fi.getPosition().x + mTab / 2 + mSpace - 4, ystart - 4, 8, 8);
                        continue;
                    }
                    TreeView.drawLineX(g, fi.getPosition().x + mTab / 2 + mSpace + 1, yend, ni.getPosition().x, Color.black);
                    TreeView.drawLineY(g, fi.getPosition().x + mTab / 2 + mSpace, ystart, yend, Color.black);
                    ystart = yend;
                }
            }
        } else {
            NodeItem ni = (NodeItem)o;
            this.drawNode(g, ni);
        }
    }

    protected void drawNode(Graphics g, NodeItem ni) {
        if (ni instanceof FolderItem) {
            ni.paint(g);
        } else if (ni.isVisible()) {
            ni.paint(g);
        }
    }

    private void drawBox(Graphics g, boolean flag, int x1, int y1, int w, int h) {
        g.drawRect(x1, y1, w, h);
        g.drawLine(x1 + 2, y1 + h / 2, x1 + w - 2, y1 + h / 2);
        if (!flag) {
            g.drawLine(x1 + w / 2, y1 + 2, x1 + w / 2, y1 + h - 2);
        }
    }

    protected Object isHit(int x, int y) {
        for (int i = 0; i < this.mItem.size(); ++i) {
            Object o;
            if (this.mItem.elementAt(i) == null || (o = this.isHit(this.mItem.elementAt(i), x, y)) == null) continue;
            return o;
        }
        return null;
    }

    private Object isHit(Object o, int x, int y) {
        NodeItem ni = (NodeItem)o;
        if (!ni.isVisible()) {
            return null;
        }
        Rectangle r = ni.getPosition();
        if (r.contains(x, y)) {
            return ni;
        }
        if (this.isFolder(ni)) {
            int ww = 4;
            int xx = r.x - 8;
            int yy = r.y + r.height / 2;
            if (Math.abs(x - xx) <= ww && Math.abs(y - yy) <= ww) {
                return ni;
            }
            FolderItem fi = (FolderItem)ni;
            if (fi.isOpen()) {
                for (int i = 0; i < fi.getItems().size(); ++i) {
                    Object res = this.isHit(fi.getItems().elementAt(i), x, y);
                    if (res == null) continue;
                    return res;
                }
            }
        }
        return null;
    }

    protected boolean isFolder(Object o) {
        return o instanceof FolderItem;
    }

    protected static void drawLineX(Graphics g, int x, int y, int xend, Color c) {
        g.setColor(c);
        while (x < xend) {
            g.drawLine(x, y, x, y);
            x += 2;
        }
    }

    protected static void drawLineY(Graphics g, int x, int y, int yend, Color c) {
        g.setColor(c);
        while (y < yend) {
            g.drawLine(x, y, x, y);
            y += 2;
        }
    }

    public void conv(ObjectFolder ot, Image close, Image open, Image file) {
        for (int i = 0; i < ot.getChildren().size(); ++i) {
            this.addNode(null, (ObjectNode)ot.getChildren().get(i), close, open, file);
        }
    }

    private NodeItem addNode(FolderItem parent, ObjectNode newnode, Image close, Image open, Image file) {
        if (newnode instanceof ObjectFolder) {
            FolderItem fi = this.addFolder(parent, newnode.getName(), open, close);
            for (int i = 0; i < ((ObjectFolder)newnode).getChildren().size(); ++i) {
                ObjectNode node = (ObjectNode)((ObjectFolder)newnode).getChildren().get(i);
                this.addNode(fi, node, close, open, file);
            }
            return fi;
        }
        return this.addNode(parent, newnode.getName(), file);
    }

    public NodeItem addNode(Object parent, String title, Image ri) {
        NodeItem node = new NodeItem(parent, title, ri, mSpace, this.mFont);
        if (parent == null) {
            this.mItem.addElement(node);
        } else if (this.isFolder(parent)) {
            ((FolderItem)parent).addChild((Object)node);
        }
        return node;
    }

    public FolderItem addFolder(Object parent, String title, Image ri, Image fi) {
        FolderItem folder = new FolderItem(parent, title, ri, fi, mSpace, this.mFont);
        if (folder == null) {
            return null;
        }
        if (parent == null) {
            this.mItem.addElement(folder);
        } else if (this.isFolder(parent)) {
            ((FolderItem)parent).addChild((Object)folder);
        }
        return folder;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.mPrefWidth > 0) {
            d.width = this.mPrefWidth;
        }
        if (this.mPrefHeight > 0) {
            d.height = this.mPrefHeight;
        }
        return d;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mFocusItem != null) {
            this.mActionContainer.actionlostfocus((ActionItem)((NodeItem)this.mFocusItem));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mPresTmp = this.isHit(e.getX(), e.getY());
        if (!this.isFolder(this.mPresTmp)) {
            NodeItem ni = (NodeItem)this.mPresTmp;
            if (ni == null) {
                return;
            }
            if (ni != this.mActiveItem) {
                if (this.mActiveItem != null) {
                    this.mActiveItem.setActive(false);
                }
                ni.setActive(true);
                this.mActiveItem = ni;
                if (!this.mPanintLock) {
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Object o = this.isHit(e.getX(), e.getY());
        if (o != null && o == this.mPresTmp) {
            if (this.isFolder(this.mPresTmp)) {
                ((FolderItem)this.mPresTmp).flipOpen();
                this.folderOpenClose();
                this.updatePos();
                if (!this.mPanintLock) {
                    this.repaint();
                }
            } else {
                NodeItem ni = (NodeItem)this.mPresTmp;
                if (ni != this.mActiveItem) {
                    if (this.mActiveItem != null) {
                        this.mActiveItem.setActive(false);
                    }
                    ni.setActive(true);
                    this.mActiveItem = ni;
                    if (!this.mPanintLock) {
                        this.repaint();
                    }
                }
                this.mActionContainer.actionperform((ActionItem)ni);
            }
        }
        this.mPresTmp = null;
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        Object o = this.isHit(e.getX(), e.getY());
        if (o == this.mFocusItem) {
            return;
        }
        if (o != this.mFocusItem && this.mFocusItem != null) {
            this.mActionContainer.actionlostfocus((ActionItem)((NodeItem)this.mFocusItem));
        }
        if (o == null || o instanceof FolderItem) {
            this.mFocusItem = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.mFocusItem = o;
        this.mActionContainer.actionfocus((ActionItem)((NodeItem)this.mFocusItem));
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.mVbar) {
            this.mScroll.y = e.getValue();
        } else if (e.getSource() == this.mHbar) {
            this.mScroll.x = e.getValue();
        }
        this.updatePos();
        if (!this.mPanintLock) {
            this.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.mDispPop = false;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.mDispPop = false;
    }

    protected synchronized void goPop(MouseEvent e) {
        this.createContext();
        if (this.mPopup.getItemCount() != 0) {
            this.mDispPop = true;
            this.mPopup.show(this, e.getX(), e.getY());
        }
    }

    protected void createContext() {
    }

    protected NodeItem getNextItem(NodeItem ni) {
        int index = ni.mIndex;
        if (index + 1 >= this.mMaxIndex) {
            return null;
        }
        return this.searchIndex(index + 1);
    }

    protected NodeItem getPrevItem(NodeItem ni) {
        int index = ni.mIndex;
        if (index == 0) {
            return null;
        }
        return this.searchIndex(index - 1);
    }

    protected NodeItem searchIndex(int index) {
        for (int i = 0; i < this.mItem.size(); ++i) {
            NodeItem tmp = this.searchIndex(index, (NodeItem)this.mItem.elementAt(i));
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }

    protected NodeItem searchIndex(int index, NodeItem ni) {
        FolderItem fi;
        if (ni.mIndex == index) {
            return ni;
        }
        if (this.isFolder(ni) && (fi = (FolderItem)ni).isOpen()) {
            for (int i = 0; i < fi.getItems().size(); ++i) {
                NodeItem tmp = this.searchIndex(index, (NodeItem)fi.getItems().elementAt(i));
                if (tmp == null) continue;
                return tmp;
            }
        }
        return null;
    }

    protected void updateScrollPos() {
        if (this.mActiveItem != null && this.mVbar.isVisible()) {
            Dimension d = this.getSize();
            if (this.mActiveItem.getPosition().y < 0) {
                this.adjustmentValueChanged(new AdjustmentEvent(this.mVbar, 0, 0, this.mScroll.y + this.mActiveItem.getPosition().y));
            } else {
                if (this.mHbar.isVisible()) {
                    d.height -= this.mHbar.getHeight();
                }
                if (d.height - (this.mActiveItem.getPosition().y + this.mActiveItem.getPosition().height) < 0) {
                    this.adjustmentValueChanged(new AdjustmentEvent(this.mVbar, 0, 0, this.mScroll.y - (d.height - (this.mActiveItem.getPosition().y + this.mActiveItem.getPosition().height))));
                }
            }
            this.updatePos();
        }
    }

    protected void setVScrollPos(int i) {
        if (this.mVbar != null && this.mVbar.isVisible()) {
            this.mVbar.setValue(i);
        }
    }

    protected int getVScrollPos() {
        if (this.mVbar != null && this.mVbar.isVisible()) {
            return this.mVbar.getValue();
        }
        return 0;
    }
}

