/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.kitec.lib.util.MessageUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpIOUtil {
    private static final Log log = LogFactory.getLog(HttpIOUtil.class);

    public static byte[] receiveBytes(HttpServletRequest request) {
        return HttpIOUtil.receiveBytes(request, true, true);
    }

    public static byte[] receiveBytes(HttpServletRequest request, boolean decompress, boolean checkmagic) {
        try {
            return MessageUtil.receiveBytes((InputStream)request.getInputStream(), (boolean)decompress, (boolean)checkmagic);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static void sendBytes(HttpServletResponse response, byte[] obj) {
        try {
            response.setContentType("application/octet-stream");
            MessageUtil.sendBytes((OutputStream)response.getOutputStream(), (byte[])obj, (boolean)true, (boolean)true);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public static void sendBytes(HttpServletResponse response, byte[] obj, boolean compress, boolean sendMagic) {
        try {
            response.setContentType("application/octet-stream");
            MessageUtil.sendBytes((OutputStream)response.getOutputStream(), (byte[])obj, (boolean)compress, (boolean)sendMagic);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public static Object recvDataUnsafe(HttpServletRequest request) {
        try {
            return MessageUtil.recvDataUnsafe((InputStream)request.getInputStream());
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static void sendDataUnsafe(HttpServletResponse response, Object obj) {
        try {
            response.setContentType("application/octet-stream");
            MessageUtil.sendDataUnsafe((OutputStream)response.getOutputStream(), (Object)obj, (boolean)true);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
    }
}

