/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.db;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;

@Deprecated
public class ErrorLog {
    public static final String ERR_DEFAULT = "DB_ACCESS_ERROR";
    protected static String mAppName = null;
    protected static String mLogFile = null;

    public static synchronized void writeErr(Exception e) {
        ErrorLog.writeErr(e, null, ERR_DEFAULT);
    }

    public static synchronized void writeErr(Exception e, String errorpos, String err_type) {
        if (mLogFile == null) {
            return;
        }
        ErrorLog.createLock(mLogFile);
        File f = new File(mLogFile);
        FileWriter fw = null;
        try {
            fw = !f.exists() ? new FileWriter(f) : new FileWriter(f, true);
            if (fw != null) {
                fw.write(ErrorLog.getDate());
                if (e instanceof SQLException) {
                    fw.write("\u3010\u63a5\u7d9a\u969c\u5bb3\u3011 / ");
                } else {
                    fw.write("\u3010\u305d\u306e\u4ed6\u969c\u5bb3\u3011 / ");
                }
                fw.write(" " + err_type + " (" + mAppName + ") / ");
                fw.write(e.toString() + " / ");
                if (errorpos != null) {
                    fw.write(errorpos + "\r\n");
                } else {
                    StackTraceElement[] els = e.getStackTrace();
                    if (els != null && els.length > 0) {
                        fw.write(els[0].toString() + "\r\n");
                    } else {
                        fw.write("\r\n");
                    }
                }
                fw.flush();
                fw.close();
            }
        }
        catch (IOException e1) {
            fw = null;
        }
        ErrorLog.deleteLock(mLogFile);
    }

    private static void createLock(String file) {
        File lockFile = new File(file + ".lock");
        while (true) {
            if (lockFile.exists()) {
                if (lockFile.lastModified() < Calendar.getInstance().getTime().getTime() - 60000L) {
                    lockFile.delete();
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                if (!lockFile.createNewFile()) continue;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private static void deleteLock(String file) {
        File lockFile = new File(file + ".lock");
        if (lockFile.exists()) {
            lockFile.delete();
        }
    }

    private static String getDate() {
        DecimalFormat formatter = new DecimalFormat("00");
        Calendar calendar = Calendar.getInstance();
        Date currentTime = new Date();
        calendar.setTime(currentTime);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int date = calendar.get(5);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        return year + "\u5e74" + formatter.format(month) + "\u6708" + formatter.format(date) + "\u65e5" + formatter.format(hour) + "\u6642" + formatter.format(min) + "\u5206" + formatter.format(sec) + "\u79d2";
    }
}

