/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.db;

import d.d;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class ConnectionObject {
    private String mConnectionTag;
    private String mUrl;
    private String mUser;
    private String mPasswd;
    private String mDriver;
    private String mCheckSQL;
    private ObjectPool mObjectPool = null;
    private String mDefEnc;
    private boolean mUsePool = true;

    public ConnectionObject(String tag, String url, String user, String passwd, String driver, String checkSQL, boolean usePool) {
        this.mConnectionTag = tag;
        this.mUrl = url;
        this.mUser = user;
        this.mPasswd = passwd;
        this.mDriver = driver;
        this.mCheckSQL = checkSQL;
        this.loadDriver();
        if (this.mUsePool) {
            this.createConnectionPool();
        }
    }

    public void setDefEncode(String enc) {
        this.mDefEnc = enc;
    }

    public String getDefEncode() {
        return this.mDefEnc;
    }

    public Connection getConnection() throws Exception {
        Connection c = null;
        if (this.mUsePool) {
            c = (Connection)this.mObjectPool.borrowObject();
            if (d.d) {
                int numActive = 0;
                int numIdle = 0;
                numActive = ((GenericObjectPool)this.mObjectPool).getNumActive();
                numIdle = ((GenericObjectPool)this.mObjectPool).getNumIdle();
                System.out.println("active:" + numActive);
                System.out.println("Idle  :" + numIdle);
            }
        } else {
            c = DriverManager.getConnection(this.mUrl, this.mUser, this.mPasswd);
        }
        return c;
    }

    protected void createConnectionPool() {
        try {
            this.mObjectPool = new GenericObjectPool(null);
            ((GenericObjectPool)this.mObjectPool).setMaxIdle(30);
            ((GenericObjectPool)this.mObjectPool).setMaxActive(30);
            DriverManagerConnectionFactory conFactory = new DriverManagerConnectionFactory(this.mUrl, this.mUser, this.mPasswd);
            new PoolableConnectionFactory((ConnectionFactory)conFactory, this.mObjectPool, null, this.mCheckSQL, false, true);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public String getTag() {
        return this.mConnectionTag;
    }

    public boolean isMatchTag(String s) {
        return s != null && s.equalsIgnoreCase(this.mConnectionTag);
    }

    private void loadDriver() {
        try {
            Class.forName(this.mDriver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

