/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.db;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public class KResultSet
implements ResultSet {
    private int maxRows = 0;
    private Vector listeners = new Vector();
    private Object[] param_obj_array = null;
    private int[] param_type_array = null;
    private ArrayList rows = null;
    private int index = 0;
    private boolean last_null = false;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int fetchDirection = 1002;
    private int fetchSize = 0;
    private ResultSetMetaData rs_meta = null;
    private Hashtable columnName = null;
    private Hashtable columnFullName = null;

    public void buildResultSet(ResultSet rs) throws SQLException {
        this.resultSetType = rs.getType();
        this.resultSetConcurrency = rs.getConcurrency();
        this.rs_meta = rs.getMetaData();
        int colnum = this.rs_meta.getColumnCount();
        this.columnName = new Hashtable();
        this.columnFullName = new Hashtable();
        for (int i = 1; i <= colnum; ++i) {
            String colname = this.rs_meta.getColumnName(i);
            String colfull = this.rs_meta.getTableName(i) + "." + colname;
            Integer colno = i - 1;
            this.columnName.put(colname, colno);
            this.columnFullName.put(colfull, colno);
        }
        int rowcount = 0;
        this.rows = new ArrayList();
        while (rs.next()) {
            ArrayList<Object> vecrow = new ArrayList<Object>(colnum);
            for (int i = 1; i <= colnum; ++i) {
                Object obj = rs.getObject(i);
                if (rs.wasNull()) {
                    obj = null;
                }
                vecrow.add(obj);
            }
            this.rows.add(vecrow);
            if (this.maxRows == 0 || ++rowcount < this.maxRows) continue;
            break;
        }
        rs.close();
    }

    public void clearParameters() throws SQLException {
        if (this.param_obj_array != null && this.param_type_array != null) {
            int i;
            for (i = 0; i < this.param_obj_array.length; ++i) {
                this.param_obj_array[i] = null;
            }
            for (i = 0; i < this.param_type_array.length; ++i) {
                this.param_type_array[i] = 0;
            }
        } else {
            throw new SQLException("mysql error : clearParameters(), no parameter.");
        }
    }

    @Override
    public boolean next() throws SQLException {
        int row_count = this.rows.size();
        if (this.index + 1 <= row_count) {
            ++this.index;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        this.rows = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.last_null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object retval = this.getObject(columnIndex);
        return retval != null ? retval.toString() : null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        try {
            return Boolean.valueOf(s);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        try {
            return Byte.valueOf(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        try {
            return Short.valueOf(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        try {
            return Integer.valueOf(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        try {
            return Long.valueOf(s);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        try {
            return Float.valueOf(s).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        try {
            return Double.valueOf(s);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)this.getObject(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.getObject(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getObject(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getObject(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getObject(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.getObject(columnIndex);
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.getObject(columnIndex);
        return null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] bin_buf = this.getBytes(columnIndex);
        if (bin_buf == null) {
            return null;
        }
        return new ByteArrayInputStream(bin_buf);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return "";
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs_meta;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            ArrayList rowdata = (ArrayList)this.rows.get(this.index - 1);
            Object data = rowdata.get(columnIndex - 1);
            this.last_null = data == null;
            return data;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String name) throws SQLException {
        try {
            Integer nI = (Integer)this.columnName.get(name);
            if (nI == null) {
                nI = (Integer)this.columnFullName.get(name);
            }
            if (nI != null) {
                return nI + 1;
            }
            throw new SQLException("Invalid column name : " + name);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, 10);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        int row_count = this.rows.size();
        return row_count > 0 && this.index == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        int row_count = this.rows.size();
        return row_count > 0 && this.index == row_count + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        int row_count = this.rows.size();
        return row_count > 0 && this.index == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        int row_count = this.rows.size();
        return row_count > 0 && this.index == row_count;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int row_count = this.rows.size();
        if (row_count > 0) {
            this.index = 0;
            this.notifyCursorMoved();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int row_count = this.rows.size();
        if (row_count > 0) {
            this.index = row_count + 1;
            this.notifyCursorMoved();
        }
    }

    @Override
    public boolean first() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int row_count = this.rows.size();
        if (row_count > 0) {
            this.index = 1;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int row_count = this.rows.size();
        if (row_count > 0) {
            this.index = row_count;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        return this.index;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        if (row == 0) {
            return false;
        }
        int row_count = this.rows.size();
        if (row < 0) {
            row = row_count + 1 + row;
        }
        this.index = row;
        if (this.index >= 1 && this.index <= row_count) {
            this.notifyCursorMoved();
            return true;
        }
        if (this.index <= 0) {
            this.beforeFirst();
        } else {
            this.afterLast();
        }
        return false;
    }

    @Override
    public boolean relative(int row) throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int row_count = this.rows.size();
        this.index += row;
        if (this.index >= 1 && this.index <= row_count) {
            this.notifyCursorMoved();
            return true;
        }
        if (this.index <= 0) {
            this.beforeFirst();
        } else {
            this.afterLast();
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        if (this.index - 1 >= 1) {
            --this.index;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("mysql does not support rowUpdated().");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("mysql does not support rowInserted().");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("mysql does not support rowDeleted().");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("mysql does not support updateNull(int).");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("mysql does not support updateBoolean(int, boolean).");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("mysql does not support updateByte(int, byte).");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("mysql does not support updateShort(int, short).");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("mysql does not support updateInt(int, int).");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("mysql does not support updateLong(int, long).");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("mysql does not support updateFloat(int, float).");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("mysql does not support updateDouble(int, double).");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("mysql does not support updateBigDecimal(int, BigDecimal).");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("mysql does not support updateString(int, String).");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("mysql does not support updateBytes(int, byte[]).");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("mysql does not support updateDate(int, Date).");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("mysql does not support updateTime(int, Time).");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("mysql does not support updateTimestamp(int, Timestamp).");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("mysql does not support updateAsciiStream(int, InputStream, int).");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("mysql does not support updateBinaryStream(int, InputStream, int).");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("mysql does not support updateCharacterStream(int, Reader, int).");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("mysql does not support updateObject(int, Object, int).");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("mysql does not support updateObject(int, Object).");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("mysql does not support updateNull(String).");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("mysql does not support updateBoolean(String, boolean).");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException("mysql does not support updateByte(String, byte).");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException("mysql does not support updateShort(String, short).");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException("mysql does not support updateInt(String, int).");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException("mysql does not support updateLong(String, long).");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException("mysql does not support updateFloat(String, float).");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException("mysql does not support updateDouble(String, double).");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException("mysql does not support updateBigDecimal(String, BigDecimal).");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("mysql does not support updateString(String, String).");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException("mysql does not support updateBytes(String, byte[]).");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException("mysql does not support updateDate(String, Date).");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException("mysql does not support updateTime(String, Time).");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException("mysql does not support updateTimestamp(String, Timestamp).");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("mysql does not support updateAsciiStream(String, InputStream, int).");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("mysql does not support updateBinaryStream(String, InputStream, int).");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLException("mysql does not support updateCharacterStream(String, Reader, int).");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException("mysql does not support updateObject(String, Object, int).");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException("mysql does not support updateObject(String, Object).");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("mysql does not support updateRow().");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("mysql does not support updateRow().");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("mysql does not support deleteRow().");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("mysql does not support refreshRow().");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("mysql does not support cancelRowUpdates().");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("mysql does not support moveToInsertRow().");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("mysql does not support moveToCurrentRow().");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new SQLException("mysql does not support getObject(int, Map).");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLException("mysql does not support getRef(int).");
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new SQLException("mysql does not support getBlob(int).");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new SQLException("mysql does not support getClob(int).");
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLException("mysql does not support getArray(int).");
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw new SQLException("mysql does not support getObject(String, Map).");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new SQLException("mysql does not support getRef(String).");
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new SQLException("mysql does not support getBlob(String).");
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new SQLException("mysql does not support getClob(String).");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new SQLException("mysql does not support getArray(String).");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLException("mysql does not support getURL(int).");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new SQLException("mysql does not support getURL(String).");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("mysql does not support updateRef(int, Ref).");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException("mysql does not support updateRef(String, Ref).");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("mysql does not support updateBlob(int, Blob).");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new SQLException("mysql does not support updateBlob(String, Blob).");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("mysql does not support updateClob(int, Blob).");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new SQLException("mysql does not support updateClob(String, Blob).");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("mysql does not support updateArray(int, Array).");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLException("mysql does not support updateArray(String, Array).");
    }

    private void notifyCursorMoved() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowsetevent = new RowSetEvent((RowSet)((Object)this));
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).cursorMoved(rowsetevent);
            }
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int arg0) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String arg0) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(int arg0) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String arg0) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int arg0) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String arg0) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(int arg0) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String arg0) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int arg0) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String arg0) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateClob(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateClob(String arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateClob(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateClob(String arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateNClob(int arg0, NClob arg1) throws SQLException {
    }

    @Override
    public void updateNClob(String arg0, NClob arg1) throws SQLException {
    }

    @Override
    public void updateNClob(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateNClob(String arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void updateNClob(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateNClob(String arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void updateNString(int arg0, String arg1) throws SQLException {
    }

    @Override
    public void updateNString(String arg0, String arg1) throws SQLException {
    }

    @Override
    public void updateRowId(int arg0, RowId arg1) throws SQLException {
    }

    @Override
    public void updateRowId(String arg0, RowId arg1) throws SQLException {
    }

    @Override
    public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
    }

    @Override
    public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
    }
}

