/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 */

package jp.kitec.lib.util.tree

import scala.reflect.BeanProperty

class WrappedObjectNode(val on: ObjectNode) {
  /**
   * 指定された名前、親、およびデータを持つ新たなノードを構築する。
   *
   * @param name		このノードの名前
   * @param parent	このノードの親
   * @param o		このノードに対応するデータ
   * @since 2002/12/20
   * @author Kawae
   * @version 2002/12/20
   */

  /**ノード名 */
  def name: String = on.getName
  def name_=(n: String) = on.setName(n)

  /**ノードに対応するデータ */
  def value: AnyRef = on.getObject
  def value_=(v: AnyRef) = on.setObject(v)

  /**このノードの親 */
  def parent: ObjectFolder = on.getParent
  def parent_=(p: ObjectFolder) = on.setParent(p)

  /**
   * Stringの取得
   * 存在しない場合はnullを返す
   *
   * @param on
   */
  def getStringOpt: Option[String] = {
    on.getObject() match {
      case v: String => Some(v);
      case _ => None
    }
  }

  /**
   * int値の取得
   *
   * @param on
   */
  def getIntOpt: Option[Int] = {
    getStringOpt match {
      case Some(v) =>
        try {
          Some(v.toInt)
        } catch {
          case e: NumberFormatException => None
        }
      case None => None
    }
  }

  /**
   * float値の取得
   *
   * @param on
   */
  def getFloatOpt: Option[Float] = {
    getStringOpt match {
      case Some(v) =>
        try {
          Some(v.toFloat)
        } catch {
          case e: NumberFormatException => None
        }
      case None => None
    }
  }

  /**
   * double値の取得
   *
   * @param on
   */
  def getDoubleOpt: Option[Double] = {
    getStringOpt match {
      case Some(v) =>
        try {
          Some(v.toDouble)
        } catch {
          case e: NumberFormatException => None
        }
      case None => None
    }
  }

  /**
   * boolの取得
   *
   * @param on
   */
  def getBoolOpt: Option[Boolean] = {
    getStringOpt match {
      case Some(v) => v.trim match {
        case "1" => Some(true)
        case "0" => Some(false)
        case _ => None
      }
      case _ => None
    }
  }
}
