/*
 * Copyright (c) 2011 KITec Inc,.. All rights reserved.
 */

package jp.kitec.lib.util.tree

import scala.collection.JavaConversions._
import scala.collection.mutable.ArrayBuffer
import java.util.Collection
import java.util.StringTokenizer

class WrappedObjectFolder(of: ObjectFolder) {

  /**
   * このノードが保持する階層構造の直下の階層を対象として、指定された
   * 名前を持つノード（親ノード含む）を検索し、該当するノードが存在
   * する場合、そのノードを返す。
   *
   * @param name	ノードの名前
   * @return ノード。該当するノードが存在しない場合は、null。
   * @see #getNode(String, boolean)
   * @since 2002/12/20
   * @author Kawae
   * @version 2002/12/20
   */
  def apply(name: String): Option[ObjectNode] = apply(name, true)

  /**
   * このノードが保持する階層構造の直下の階層を対象として、指定された
   * 名前を持つノード、または親ノードを検索し、該当するノードが存在
   * する場合、そのノードを返す。
   *
   * @param name				ノードの名前
   * @param includeFolder	親ノードを検索対象とする場合、true。
   * 							false を指定すると、名前が一致しても
   * 							対象からは除外される。
   * @return ノード。該当するノードが存在しない場合は、null。
   * @see #getNode(String, boolean)
   * @since 2002/12/20
   * @author Kawae
   * @version 2002/12/20
   */
  def apply(name: String, includeFolder: Boolean): Option[ObjectNode] = {
    val target: Seq[ObjectNode] = if (includeFolder) of.getChildren() else of.getChildren().filterNot(_.isInstanceOf[ObjectFolder])
    return target.find(_.getName() == name)
  }

  /**
   * このノードが保持する階層構造のノード群（子ノード）を返す。
   *
   * @return ノード群
   * @since 2002/12/20
   * @author Kawae
   * @version 2002/12/20
   */
  def children = of.getChildren()


//  /**
//   * このノードが保持する階層構造のノード群（子ノード）を返す。
//   *
//   * @param インデックス
//   * @return ノード群p
//   * @since 2002/12/20
//   * @author Kawae
//   * @version 2002/12/20
//   */
//  def children(idx: Int) = mChildren(idx)
//
//  /**
//   * このノードの階層構造のすべての階層を対象として、指定された名前と
//   * 同じ名前を持つノードを検索し、そのノードを返す。
//   * 同じ名前を持つノードが複数存在する場合、次の内容でノードが優先度
//   * が決まる。
//   * (1)所属する階層が異なる場合、階層が上のノード
//   * (2)同じ階層の場合、最初に見つかった（先に追加された）ノード
//   *
//   * @param name	ノードの名前
//   * @return 指定された名前と同じ名前を持つノード
//   * @since 2002/12/20
//   * @author Kawae
//   * @version 2002/12/20
//   */
//  def findNode(name: String): Option[ObjectNode] = {
//    //  val (folders, nodes) = mChildren.partition(_.isInstanceOf[ObjectFolder])
//    //  nodes.find(_.name == name) match {
//    //  case Some(v) => return Some(v)
//    //  }
//    //FIXME (1)を満たしてるかテスト
//
//    var target: Option[ObjectNode] = None
//
//    for (on <- mChildren) {
//      on match {
//        case of: ObjectFolder => of.findNode(name) match {
//          case o: Some[ObjectNode] => target = o
//          case _ =>
//        }
//        case on => if (on.name == name) {
//          return Some(on)
//        }
//      }
//    }
//    return target
//  }

  /**
   * ObjectFolderに値を設定
   * 同名の要素がある場合は上書き
   * @param name
   * @param val
   * @author kawae
   * @since 2004/11/05
   */
  def update(name: String, value: Any) {
    val str = value match {
      case b: Boolean => if (b) "1" else "0"
      case _ => value.toString
    }
    of.getNode(name, false) match {
      case on: ObjectNode =>
        on.setObject(str)
      case _ =>
        of.addChild(new ObjectNode(name, str))
    }
  }

  def apply(idx: Int) = of.getChildren().get(idx)

  import _root_.jp.kitec.kwt.KwtConversion._

  def getNodeInt(name: String): Option[Int] =
    Option(of.getNode(name, false)).flatMap(_.getIntOpt)

  def getNodeFloat(name: String): Option[Float] =
    Option(of.getNode(name, false)).flatMap(_.getFloatOpt)

  def getNodeDouble(name: String): Option[Double] =
    Option(of.getNode(name, false)).flatMap(_.getDoubleOpt)

  def getNodeBool(name: String): Option[Boolean] =
    Option(of.getNode(name, false)).flatMap(_.getBoolOpt)

  def getNodeString(name: String): Option[String] =
    Option(of.getNode(name, false)).flatMap(_.getStringOpt)

//  def getNodeValue[T](name: String, defaultValue: T): T = {
//    getNode(name) match {
//      case Some(v) =>
//        defaultValue match {
//          case t: String => v.getNodeString(t).asInstanceOf[T]
//          case t: Int => ObjectNode.getNodeInt(v, t).asInstanceOf[T]
//          case t: Double => ObjectNode.getNodeDouble(v, t).asInstanceOf[T]
//          case t: Float => ObjectNode.getNodeFloat(v, t).asInstanceOf[T]
//          case t: Boolean => ObjectNode.getNodeBool(v, t).asInstanceOf[T]
//          case _ => throw new UnsupportedOperationException
//        }
//      case None => defaultValue
//    }
//  }
}
