package jp.kitec.kwt

import jp.kitec.kwt.wrap.RichArea
import jp.kitec.kwt.wrap.RichLineType
import jp.kitec.kwt.wrap.RichRotatedArea
import jp.kitec.kwt.wrap.RichViewPort
import jp.kitec.lib.util.tree.ObjectFolder
import jp.kitec.lib.util.tree.ObjectNode
import jp.kitec.lib.util.tree.WrappedObjectFolder
import jp.kitec.lib.util.tree.WrappedObjectNode

object KwtConversion {
  implicit def areaWrapper(area: KArea) = new RichArea(area)
  implicit def rotatedAreaWrapper(area: KRotatedArea) = new RichRotatedArea(area)
  implicit def lineTypeWrapper(lt: KLineType) = new RichLineType(lt)
  implicit def viewPortWrapper(vp: KViewPort) = new RichViewPort(vp)

  implicit def objectNodeWrapper(on: ObjectNode) = new WrappedObjectNode(on)
  implicit def objectFolderWrapper(of: ObjectFolder) = new WrappedObjectFolder(of)
}
