/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.util;

import option.io.pdfcommon.util.PdfUtil;

public class PdfMetrices {
    private static final int MATRIX_SIZE = 3;
    public static final int TRANSLATE = 1;
    public static final int ROTATE = 2;
    public static final int SCALE = 3;
    public static final int SKEW = 4;
    public static final int TEXT_TYPE = 1;
    public static final int IMAGE_TYPE = 2;
    public static final int FORM_TYPE = 3;
    private int[] mTranformOrder = new int[4];
    private float[][] mMatrix = new float[3][3];
    private boolean isTranslate = false;
    private boolean isScale = false;
    private boolean isRotate = false;
    private boolean isSkew = false;
    private float tx;
    private float ty;
    private float sx;
    private float sy;
    private float rotateTheta;
    private float skewXAng;
    private float skewYAng;
    private int mType = 0;
    private PdfUtil mPdfUtil = new PdfUtil();

    public PdfMetrices(int type) {
        this.mType = type;
        this.initTransformOrder();
    }

    public void setTranslation(float tx, float ty) {
        this.tx = tx;
        this.ty = ty;
        this.isTranslate = true;
    }

    public float getTranslationX() {
        return this.tx;
    }

    public float getTranslationY() {
        return this.ty;
    }

    public void setScale(float sx, float sy) {
        this.sx = sx;
        this.sy = sy;
        this.isScale = true;
    }

    public float getScaleX() {
        return this.sx;
    }

    public float getScaleY() {
        return this.sy;
    }

    public void setRotation(float angle) {
        this.rotateTheta = (float)Math.PI * angle / 180.0f;
        this.isRotate = true;
    }

    public float getRotateTheta() {
        return this.rotateTheta;
    }

    public void setSkew(float angleX, float angleY) {
        this.skewXAng = (float)Math.PI * angleX / 180.0f;
        this.skewYAng = (float)Math.PI * angleY / 180.0f;
        this.isSkew = true;
    }

    public float getSkewX() {
        return this.skewXAng;
    }

    public float getSkewY() {
        return this.skewYAng;
    }

    public String toString() {
        this.identity(this.mMatrix);
        float[][] tmp = new float[3][3];
        int[] nArray = this.mTranformOrder;
        int n = this.mTranformOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            switch (element) {
                case 1: {
                    if (!this.isTranslate) break;
                    this.identity(tmp);
                    tmp[2][0] = this.tx;
                    tmp[2][1] = this.ty;
                    this.mMatrix = this.multiply(tmp, this.mMatrix);
                    break;
                }
                case 3: {
                    if (!this.isScale) break;
                    this.identity(tmp);
                    tmp[0][0] = this.sx;
                    tmp[1][1] = this.sy;
                    this.mMatrix = this.multiply(tmp, this.mMatrix);
                    break;
                }
                case 2: {
                    if (!this.isRotate) break;
                    this.identity(tmp);
                    float cos = (float)Math.cos(this.rotateTheta);
                    float sin = (float)Math.sin(this.rotateTheta);
                    tmp[0][0] = cos;
                    tmp[0][1] = -sin;
                    tmp[1][0] = sin;
                    tmp[1][1] = cos;
                    this.mMatrix = this.multiply(tmp, this.mMatrix);
                    break;
                }
                case 4: {
                    if (!this.isSkew) break;
                    this.identity(tmp);
                    float tanX = (float)Math.tan(this.skewXAng);
                    float tanY = (float)Math.tan(this.skewYAng);
                    tmp[0][0] = 1.0f;
                    tmp[0][1] = tanX;
                    tmp[1][0] = tanY;
                    tmp[1][1] = 1.0f;
                    this.mMatrix = this.multiply(tmp, this.mMatrix);
                    break;
                }
            }
            ++n2;
        }
        return this.toString(this.mMatrix[0][0], this.mMatrix[0][1], this.mMatrix[1][0], this.mMatrix[1][1], this.mMatrix[2][0], this.mMatrix[2][1]);
    }

    private void identity(float[][] mat) {
        if (mat == null) {
            return;
        }
        int line = mat.length;
        int row = mat[0].length;
        int i = 0;
        while (i < line) {
            int j = 0;
            while (j < row) {
                mat[i][j] = i == j ? 1 : 0;
                ++j;
            }
            ++i;
        }
    }

    public String toString(float a, float b, float c, float d2, float e, float f) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.mPdfUtil.formatPrint(a)) + " ");
        sb.append(String.valueOf(this.mPdfUtil.formatPrint(b)) + " ");
        sb.append(String.valueOf(this.mPdfUtil.formatPrint(c)) + " ");
        sb.append(String.valueOf(this.mPdfUtil.formatPrint(d2)) + " ");
        sb.append(String.valueOf(this.mPdfUtil.formatPrint(e)) + " ");
        sb.append(String.valueOf(this.mPdfUtil.formatPrint(f)) + " ");
        if (this.mType == 1) {
            sb.append("Tm\n");
        } else {
            sb.append("cm\n");
        }
        return sb.toString();
    }

    public int getType() {
        return this.mType;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public int[] getTransformOrder() {
        return this.mTranformOrder;
    }

    public void setTransformOrder(int[] transformOrder) {
        if (transformOrder == null) {
            throw new NullPointerException();
        }
        this.mTranformOrder = transformOrder;
    }

    private void initTransformOrder() {
        this.mTranformOrder[0] = 1;
        this.mTranformOrder[1] = 2;
        this.mTranformOrder[2] = 3;
        this.mTranformOrder[3] = 4;
    }

    public float[][] multiply(float[][] m1, float[][] m2) {
        if (m1 == null || m2 == null || m1.length != m2.length) {
            throw new IllegalArgumentException();
        }
        int line = m1.length;
        int row = m1[0].length;
        float[][] result = new float[line][row];
        int i = 0;
        while (i < line) {
            int j = 0;
            while (j < row) {
                int k = 0;
                while (k < row) {
                    float[] fArray = result[i];
                    int n = j;
                    fArray[n] = fArray[n] + m1[i][k] * m2[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }
}

