/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.path;

import option.io.pdfcommon.path.DashPattern;
import option.io.pdfcommon.util.PdfUtil;

public class LineStyle {
    public static final String LN = "\r\n";
    public static final int BUTT_CAP = 0;
    public static final int ROUND_CAP = 1;
    public static final int SQUARE_CAP = 2;
    public static final int MITER_JOIN = 0;
    public static final int ROUND_JOIN = 1;
    public static final int BEVEL_JOIN = 2;
    private static PdfUtil mUtil = new PdfUtil();
    private int lineJoinStyle = 0;
    private DashPattern lineDashPattern = new DashPattern();
    private float lineWidth = 0.1f;
    private int lineCapStyle = 0;

    private static String format(float width) {
        return mUtil.formatPrint(width);
    }

    public LineStyle() {
    }

    public LineStyle(DashPattern dp) {
        this.setLineDashPattern(dp);
    }

    public LineStyle(float width) {
        this.setLineWidth(width);
    }

    public LineStyle(float width, DashPattern dp) {
        this.setLineWidth(width);
        this.setLineDashPattern(dp);
    }

    public String toString() {
        return LineStyle.format(this.lineWidth) + " w" + LN + this.lineDashPattern.toString();
    }

    public int getLineCapStyle() {
        return this.lineCapStyle;
    }

    public DashPattern getLineDashPattern() {
        return this.lineDashPattern;
    }

    public int getLineJoinStyle() {
        return this.lineJoinStyle;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineCapStyle(int i) {
        this.lineCapStyle = i;
    }

    public void setLineDashPattern(DashPattern pattern) {
        this.lineDashPattern = pattern;
    }

    public void setLineJoinStyle(int i) {
        this.lineJoinStyle = i;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineStyle)) {
            return false;
        }
        LineStyle rhs = (LineStyle)o;
        if (rhs.lineWidth != this.lineWidth) {
            return false;
        }
        if (rhs.lineCapStyle != this.lineCapStyle) {
            return false;
        }
        if (rhs.lineJoinStyle != this.lineJoinStyle) {
            return false;
        }
        return this.lineDashPattern.equals(rhs.lineDashPattern);
    }
}

